/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class V2CMD5Value {
    final MessageDigest mdMD5;
    long lHV;
    long lLV;
    private static final int[] ilB32HC2I = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};

    static V2CMD5Value createInstance() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return new V2CMD5Value(messageDigest);
    }

    public V2CMD5Value() {
        this((MessageDigest)null);
    }

    public V2CMD5Value(V2CMD5Value v2CMD5Value) {
        this(v2CMD5Value.lHV, v2CMD5Value.lLV);
    }

    public V2CMD5Value(long l, long l2) {
        this((MessageDigest)null);
        this.lHV = l;
        this.lLV = l2;
    }

    private V2CMD5Value(MessageDigest messageDigest) {
        this.mdMD5 = messageDigest;
    }

    void reset() {
        this.mdMD5.reset();
    }

    void update(byte[] byArray, int n, int n2) {
        this.mdMD5.update(byArray, n, n2);
    }

    void digest() {
        byte[] byArray = this.mdMD5.digest();
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n2 = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        this.lHV = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        int n3 = (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
        int n4 = (byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF;
        this.lLV = (long)n3 << 32 | (long)n4 & 0xFFFFFFFFL;
    }

    private static int b32HCharToInt(char c) {
        return c >= '0' && c <= 'V' ? ilB32HC2I[c - 48] : -1;
    }

    static int revertByte(int n) {
        return n >>> 24 | n >>> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
    }

    boolean parse(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        if (string == null || string.length() < 26) {
            return false;
        }
        int n5 = 0;
        for (n4 = 25; n4 >= 20; --n4) {
            n3 = V2CMD5Value.b32HCharToInt(string.charAt(n4));
            if (n3 < 0) {
                return false;
            }
            n5 = n5 << 5 | n3;
        }
        n4 = V2CMD5Value.b32HCharToInt(string.charAt(19));
        if (n4 < 0) {
            return false;
        }
        n3 = V2CMD5Value.revertByte(n5 << 4 | n4 >>> 1);
        n5 = n4 & 1;
        for (n2 = 18; n2 >= 13; --n2) {
            n = V2CMD5Value.b32HCharToInt(string.charAt(n2));
            if (n < 0) {
                return false;
            }
            n5 = n5 << 5 | n;
        }
        n4 = V2CMD5Value.b32HCharToInt(string.charAt(12));
        if (n4 < 0) {
            return false;
        }
        this.lLV = (long)V2CMD5Value.revertByte(n5 << 1 | n4 >>> 4) << 32 | (long)n3 & 0xFFFFFFFFL;
        n5 = n4 & 0xF;
        for (n2 = 11; n2 >= 7; --n2) {
            n = V2CMD5Value.b32HCharToInt(string.charAt(n2));
            if (n < 0) {
                return false;
            }
            n5 = n5 << 5 | n;
        }
        n4 = V2CMD5Value.b32HCharToInt(string.charAt(6));
        if (n4 < 0) {
            return false;
        }
        n2 = V2CMD5Value.revertByte(n5 << 3 | n4 >>> 2);
        n5 = n4 & 3;
        for (n = 5; n >= 0; --n) {
            int n6 = V2CMD5Value.b32HCharToInt(string.charAt(n));
            if (n6 < 0) {
                return false;
            }
            n5 = n5 << 5 | n6;
        }
        this.lHV = (long)V2CMD5Value.revertByte(n5) << 32 | (long)n2 & 0xFFFFFFFFL;
        return true;
    }

    int compareTo(Object object) {
        V2CMD5Value v2CMD5Value = (V2CMD5Value)object;
        long l = this.lHV;
        long l2 = v2CMD5Value.lHV;
        if (l > l2) {
            return 1;
        }
        if (l < l2) {
            return -1;
        }
        long l3 = this.lLV;
        long l4 = v2CMD5Value.lLV;
        if (l3 > l4) {
            return 1;
        }
        if (l3 < l4) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)this.lHV;
    }

    public boolean equals(Object object) {
        if (!(object instanceof V2CMD5Value)) {
            return false;
        }
        V2CMD5Value v2CMD5Value = (V2CMD5Value)object;
        return this.lHV == v2CMD5Value.lHV && this.lLV == v2CMD5Value.lLV;
    }

    public String toString() {
        return V2CMD5Value.toB32HString(this.lHV, this.lLV);
    }

    static String toB32HString(long l, long l2) {
        char[] cArray = new char[26];
        V2CMD5Value.fillB32HChars(l, l2, cArray);
        return new String(cArray);
    }

    static void fillB32HChars(long l, long l2, char[] cArray) {
        int n = V2CMD5Value.appendB32HByte(cArray, (int)(l >> 32), 0, 0);
        n = V2CMD5Value.appendB32HByte(cArray, (int)l, n, 1);
        n = V2CMD5Value.appendB32HByte(cArray, (int)(l2 >>> 32), n, 2);
        V2CMD5Value.appendB32HByte(cArray, (int)l2, n, 3);
    }

    static int appendB32HByte(char[] cArray, int n, int n2, int n3) {
        n = V2CMD5Value.revertByte(n);
        int n4 = 32 * n3;
        int n5 = n4 / 5;
        int n6 = n4 % 5;
        if (n6 > 0) {
            cArray[n5++] = V2CMD5Value.toB32HChar(n << n6 | n2);
            n6 = 5 - n6;
            n >>>= n6;
            n6 = 32 - n6;
        } else {
            n6 = 32;
        }
        while (n6 >= 5) {
            cArray[n5++] = V2CMD5Value.toB32HChar(n);
            n >>>= 5;
            n6 -= 5;
        }
        if (n3 == 3) {
            cArray[25] = V2CMD5Value.toB32HChar(n);
        }
        return n;
    }

    static char toB32HChar(int n) {
        if ((n &= 0x1F) < 10) {
            return (char)(48 + n);
        }
        return (char)(n + 55);
    }
}

