/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class V2CMonochromeIconFactory {
    private static final int nWidth = 10;
    private static final int nHeight = 12;
    private static final int nWidth2 = 16;
    private static final int nHeight2 = 13;
    private static final int nXOffset = 3;
    private static final int nYOffset = 0;
    private static final Color cBody = new Color(0x1F1F1F);
    private static final Color cBodyS = new Color(0xDFDFDF);
    private static final Color cBG = new Color(0x9F9F9F);
    private static final Color cBGS = new Color(0x5F5F5F);
    private static final Color cLowerShadow = new Color(0x60FFFFFF, true);
    private static final Color cLowerShadowS = new Color(0x60000000, true);
    private static final HashMap hmIcons = new HashMap();

    static ImageIcon createIcon(String string, boolean bl) {
        String string2 = bl ? string + "_S" : string;
        ImageIcon imageIcon = (ImageIcon)hmIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        BufferedImage bufferedImage = V2CMonochromeIconFactory.createImage(string, true, bl);
        if (bufferedImage == null) {
            return null;
        }
        imageIcon = new ImageIcon(bufferedImage);
        hmIcons.put(string2, imageIcon);
        return imageIcon;
    }

    static BufferedImage createImage(String string) {
        return V2CMonochromeIconFactory.createImage(string, false, false);
    }

    private static BufferedImage createImage(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(bl ? 16 : 10, bl ? 13 : 12, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (bl) {
            graphics2D.translate(3, 0);
        }
        if (string.equals("Online")) {
            V2CMonochromeIconFactory.createOnline(graphics2D, bl2);
        } else if (string.equals("treepane")) {
            V2CMonochromeIconFactory.createToggleTreePane(graphics2D);
        } else if (string.equals("swchpnmd")) {
            V2CMonochromeIconFactory.createSwichPaneMode(graphics2D);
        } else if (string.equals("brdthrd")) {
            V2CMonochromeIconFactory.createSwitchRightPane(graphics2D);
        } else if (string.equals("gotoaddr")) {
            V2CMonochromeIconFactory.createGoTo(graphics2D);
        } else if (string.equals("newfav")) {
            V2CMonochromeIconFactory.createAdd(graphics2D);
        } else if (string.equals("close")) {
            V2CMonochromeIconFactory.createClose(graphics2D);
        } else if (string.equals("dustbin")) {
            V2CMonochromeIconFactory.createDelete(graphics2D);
        } else if (string.equals("delclose")) {
            V2CMonochromeIconFactory.createCloseDeletingLog(graphics2D);
        } else if (string.equals("get")) {
            V2CMonochromeIconFactory.createUpdate(graphics2D, true);
        } else if (string.equals("update")) {
            V2CMonochromeIconFactory.createUpdate(graphics2D, false);
        } else if (string.equals("histback")) {
            V2CMonochromeIconFactory.createHistoryMove(graphics2D, false);
        } else if (string.equals("histfwd")) {
            V2CMonochromeIconFactory.createHistoryMove(graphics2D, true);
        } else if (string.equals("resetdsp")) {
            V2CMonochromeIconFactory.createResetDisp(graphics2D, false);
        } else if (string.equals("resetdspa")) {
            V2CMonochromeIconFactory.createResetDisp(graphics2D, true);
        } else if (string.equals("graph")) {
            V2CMonochromeIconFactory.createGraph(graphics2D, bl2);
        } else if (string.equals("gallery")) {
            V2CMonochromeIconFactory.createThumbnail(graphics2D, bl2);
        } else if (string.equals("writepnl")) {
            V2CMonochromeIconFactory.createWrite(graphics2D, bl2);
        } else if (string.equals("postmsg")) {
            V2CMonochromeIconFactory.createPostMessage(graphics2D);
        } else if (string.equals("writeprv")) {
            V2CMonochromeIconFactory.createWritePreview(graphics2D, bl2);
        } else if (string.equals("impfile")) {
            V2CMonochromeIconFactory.createImportFile(graphics2D);
        } else {
            bufferedImage = null;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    static Color getLowerShadowColor(boolean bl) {
        return bl ? cLowerShadowS : cLowerShadow;
    }

    static Color getBodyColor(boolean bl) {
        return bl ? cBodyS : cBody;
    }

    static Color getBGColor(boolean bl) {
        return bl ? cBGS : cBG;
    }

    static void createOnline(Graphics2D graphics2D, boolean bl) {
        int n = 6;
        int n2 = 4;
        int n3 = 3;
        int n4 = 6;
        int n5 = 9;
        int[] nArray = new int[]{0, n3, n4, n5, n4, n3};
        int[] nArray2 = new int[]{n, n - n2, n + 1, n, n + n2, n - 1};
        graphics2D.setColor(V2CMonochromeIconFactory.getLowerShadowColor(bl));
        graphics2D.translate(0, 1);
        graphics2D.fillPolygon(nArray, nArray2, 6);
        graphics2D.setColor(V2CMonochromeIconFactory.getBodyColor(bl));
        graphics2D.translate(0, -1);
        graphics2D.fillPolygon(nArray, nArray2, 6);
    }

    private static void createToggleTreePane(Graphics2D graphics2D) {
        int n = 10;
        int n2 = 12;
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(4, 5, 9, 5);
        graphics2D.drawLine(0, 11, 9, 11);
        graphics2D.setColor(cBody);
        graphics2D.drawRect(0, 1, n - 1, n2 - 3);
        graphics2D.fillRect(3, 1, 2, n2 - 3);
        graphics2D.drawLine(4, 4, 9, 4);
    }

    private static void createSwichPaneMode(Graphics2D graphics2D) {
        int n = 10;
        int n2 = 12;
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(4, 6, 9, 6);
        graphics2D.drawLine(0, 11, 9, 11);
        graphics2D.setColor(cBody);
        graphics2D.drawRect(0, 1, n - 1, n2 - 3);
        graphics2D.drawLine(3, 1, 3, n2 - 3);
        graphics2D.fillRect(4, 4, n - 5, 2);
    }

    private static void createSwitchRightPane(Graphics2D graphics2D) {
        int n = 10;
        int n2 = 12;
        int[] nArray = new int[]{3, 7, 5};
        int[] nArray2 = new int[]{5, 5, 1};
        int[] nArray3 = new int[]{3, 5, 7};
        int[] nArray4 = new int[]{7, 11, 7};
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(0, 12, n - 1, 12);
        graphics2D.setColor(cBody);
        graphics2D.drawRect(0, 0, n - 1, n2 - 1);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.fillPolygon(nArray3, nArray4, 3);
        graphics2D.fillRect(4, 5, 2, 2);
    }

    static void createAdd(Graphics2D graphics2D) {
        int n = 4;
        int n2 = 5;
        int n3 = 3;
        int n4 = n3 * 2 + 2;
        int n5 = n - n3;
        int n6 = n + n3 + 1;
        int n7 = n2 - n3;
        int n8 = n2 + n3 + 1;
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(n, n8, n + 1, n8);
        graphics2D.drawLine(n5, n2 + 2, n6, n2 + 2);
        graphics2D.setColor(cBody);
        graphics2D.fillRect(n5, n2, n4, 2);
        graphics2D.fillRect(n, n7, 2, n4);
    }

    static void createClose(Graphics2D graphics2D) {
        int n = 6;
        int n2 = 4;
        int n3 = 1;
        int n4 = 9;
        int n5 = n - n2;
        int n6 = n + n2;
        int[] nArray = new int[]{n3, n3 + 1, n4, n4, n4 - 1, n3};
        int[] nArray2 = new int[]{n4, n4 - 1, n3, n3, n3 + 1, n4};
        int[] nArray3 = new int[]{n5, n5, n6 - 1, n6, n6, n5 + 1};
        V2CMonochromeIconFactory.fillTriplePolygon(graphics2D, nArray, nArray3, nArray2, nArray3);
    }

    static void createDelete(Graphics2D graphics2D) {
        int n;
        int n2 = n = 5;
        int n3 = n2 * 2 - 1;
        int n4 = 6;
        int n5 = n - n2;
        int n6 = n4 - n2;
        int n7 = 2;
        graphics2D.setStroke(new BasicStroke(1.8f));
        graphics2D.setColor(cLowerShadow);
        graphics2D.translate(0, 1);
        graphics2D.drawOval(n5, n6, n3, n3);
        graphics2D.drawLine(n - n7 - 1, n4 - n7 - 1, n + n7, n4 + n7);
        graphics2D.setColor(cBody);
        graphics2D.translate(0, -1);
        graphics2D.drawOval(n5, n6, n3, n3);
        graphics2D.drawLine(n - n7 - 1, n4 - n7 - 1, n + n7, n4 + n7);
    }

    static void createCloseDeletingLog(Graphics2D graphics2D) {
        int n;
        int n2 = n = 5;
        int n3 = n2 * 2 - 1;
        int n4 = 6;
        int n5 = n - n2;
        int n6 = n4 - n2;
        int n7 = 2;
        graphics2D.setStroke(new BasicStroke(1.8f));
        graphics2D.setColor(cLowerShadow);
        graphics2D.translate(0, 1);
        graphics2D.drawOval(n5, n6, n3, n3);
        graphics2D.drawLine(n - n7 - 1, n4 - n7 - 1, n + n7, n4 + n7);
        graphics2D.drawLine(n + n7, n4 - n7 - 1, n - n7 - 1, n4 + n7);
        graphics2D.setColor(cBody);
        graphics2D.translate(0, -1);
        graphics2D.drawOval(n5, n6, n3, n3);
        graphics2D.drawLine(n - n7 - 1, n4 - n7 - 1, n + n7, n4 + n7);
        graphics2D.drawLine(n + n7, n4 - n7 - 1, n - n7 - 1, n4 + n7);
    }

    private static void createUpdate(Graphics2D graphics2D, boolean bl) {
        int n;
        int n2 = n = 5;
        int n3 = n2 * 2 - 2;
        int n4 = 8;
        int n5 = n - n2 + 1;
        int n6 = n4 - n2;
        int n7 = 3;
        int[] nArray = new int[]{n - 1, n - 1, n + n7 + 1};
        int[] nArray2 = new int[]{n6 - n7, n6 + 1 + n7, n6 + 1};
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(1.8f);
        graphics2D.setColor(cLowerShadow);
        graphics2D.translate(0, 1);
        V2CMonochromeIconFactory.drawUpdate(graphics2D, stroke, basicStroke, n5, n6, n3, nArray, nArray2, bl);
        graphics2D.setColor(cBody);
        graphics2D.translate(0, -1);
        V2CMonochromeIconFactory.drawUpdate(graphics2D, stroke, basicStroke, n5, n6, n3, nArray, nArray2, bl);
    }

    private static void drawUpdate(Graphics2D graphics2D, Stroke stroke, Stroke stroke2, int n, int n2, int n3, int[] nArray, int[] nArray2, boolean bl) {
        graphics2D.setStroke(stroke2);
        graphics2D.drawArc(n, n2, n3, n3, 90, bl ? 250 : 220);
        graphics2D.setStroke(stroke);
        graphics2D.fillPolygon(nArray, nArray2, 3);
    }

    static void createHistoryMove(Graphics2D graphics2D, boolean bl) {
        int[] nArray;
        int n;
        int n2 = 6;
        int n3 = 4;
        int n4 = n = bl ? 10 : 8;
        if (bl) {
            int[] nArray2 = new int[3];
            nArray2[0] = n;
            nArray2[1] = 2;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = n;
            nArray = nArray3;
            nArray3[2] = n;
        }
        int[] nArray4 = nArray;
        int[] nArray5 = new int[]{n2, n2 - n3, n2 + n3};
        V2CMonochromeIconFactory.fillTriplePolygon(graphics2D, nArray4, nArray5, null, null);
    }

    private static void fillTriplePolygon(Graphics2D graphics2D, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = nArray.length;
        int n2 = nArray3 != null ? nArray3.length : 0;
        graphics2D.setColor(cLowerShadow);
        graphics2D.translate(0, 1);
        graphics2D.fillPolygon(nArray, nArray2, n);
        if (n2 > 0) {
            graphics2D.fillPolygon(nArray3, nArray4, n2);
        }
        graphics2D.setColor(cBody);
        graphics2D.translate(0, -1);
        graphics2D.fillPolygon(nArray, nArray2, n);
        if (n2 > 0) {
            graphics2D.fillPolygon(nArray3, nArray4, n2);
        }
    }

    private static void createGoTo(Graphics2D graphics2D) {
        int[] nArray = new int[]{4, 4, 9};
        int[] nArray2 = new int[]{1, 11, 6};
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(1, 8, 4, 8);
        graphics2D.drawLine(5, 11, 9, 7);
        graphics2D.setColor(cBody);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.fillRect(1, 4, 3, 4);
    }

    private static void createResetDisp(Graphics2D graphics2D, boolean bl) {
        int[] nArray = new int[]{2, 8, 5};
        int[] nArray2 = new int[]{6, 6, 1};
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(2, 7, 8, 7);
        graphics2D.drawLine(4, 11, 5, 11);
        graphics2D.setColor(cBody);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.fillRect(4, 5, 2, 6);
    }

    private static void createGraph(Graphics2D graphics2D, boolean bl) {
        int n = 10;
        graphics2D.setColor(V2CMonochromeIconFactory.getLowerShadowColor(bl));
        graphics2D.drawLine(0, n + 1, n - 2, n + 1);
        graphics2D.setColor(V2CMonochromeIconFactory.getBodyColor(bl));
        graphics2D.fillRect(0, 1, 2, n - 1);
        graphics2D.fillRect(0, n - 1, n, 2);
        graphics2D.setStroke(new BasicStroke(2.0f));
        int[] nArray = new int[]{2, 6, 9};
        int[] nArray2 = new int[]{8, 6, 2};
        graphics2D.drawPolyline(nArray, nArray2, 3);
    }

    private static void createThumbnail(Graphics2D graphics2D, boolean bl) {
        for (int i = 0; i < 2; ++i) {
            int n = i * 6;
            for (int j = 0; j < 2; ++j) {
                int n2 = j * 6 + 1;
                graphics2D.setColor(V2CMonochromeIconFactory.getLowerShadowColor(bl));
                graphics2D.drawLine(n, n2 + 3 + 1, n + 3, n2 + 3 + 1);
                graphics2D.setColor(V2CMonochromeIconFactory.getBodyColor(bl));
                graphics2D.drawRect(n, n2, 3, 3);
            }
        }
    }

    private static void createWrite(Graphics2D graphics2D, boolean bl) {
        int n = 10;
        int n2 = 12;
        int[] nArray = new int[]{2, 2, 4, 9, 9};
        int[] nArray2 = new int[]{8, 10, 10, 5, 2};
        graphics2D.setColor(V2CMonochromeIconFactory.getLowerShadowColor(bl));
        graphics2D.drawLine(2, 11, 4, 11);
        graphics2D.drawLine(4, 11, 9, 6);
        graphics2D.setColor(V2CMonochromeIconFactory.getBodyColor(bl));
        graphics2D.drawRect(0, 0, n - 1, n2 - 1);
        graphics2D.fillPolygon(nArray, nArray2, 5);
    }

    private static void createPostMessage(Graphics2D graphics2D) {
        int[] nArray = new int[]{0, 5, 5};
        int[] nArray2 = new int[]{6, 1, 11};
        int[] nArray3 = new int[]{5, 8, 10, 10, 7, 5};
        int[] nArray4 = new int[]{9, 9, 11, 7, 4, 4};
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(0, 7, 5, 12);
        graphics2D.drawLine(5, 10, 8, 10);
        graphics2D.drawLine(8, 10, 10, 12);
        graphics2D.setColor(cBody);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.fillPolygon(nArray3, nArray4, 6);
    }

    private static void createWritePreview(Graphics2D graphics2D, boolean bl) {
        Shape shape = graphics2D.getClip();
        graphics2D.setColor(V2CMonochromeIconFactory.getLowerShadowColor(bl));
        graphics2D.setClip(-4, 6, 16, 12);
        graphics2D.fillOval(-3, -5, 16, 16);
        graphics2D.setColor(V2CMonochromeIconFactory.getBodyColor(bl));
        graphics2D.setClip(-4, 0, 16, 6);
        graphics2D.fillOval(-3, 2, 16, 16);
        graphics2D.setClip(-4, 6, 16, 12);
        graphics2D.fillOval(-3, -6, 16, 16);
        graphics2D.setClip(shape);
        graphics2D.setColor(V2CMonochromeIconFactory.getBGColor(bl));
        graphics2D.fillOval(3, 4, 4, 4);
        graphics2D.setColor(V2CMonochromeIconFactory.getBodyColor(bl));
        graphics2D.fillOval(4, 5, 2, 2);
    }

    private static void createImportFile(Graphics2D graphics2D) {
        int[] nArray = new int[]{2, 5, 8};
        int[] nArray2 = new int[]{7, 12, 7};
        graphics2D.setColor(cLowerShadow);
        graphics2D.drawLine(2, 8, 5, 13);
        graphics2D.drawLine(5, 13, 8, 8);
        graphics2D.setColor(cBody);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.fillRect(4, 1, 2, 6);
    }
}

