/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.mac.V2CMacApplicationHandler;

public abstract class V2CMouseExitGlassPane
extends JPanel
implements AWTEventListener {
    private final Window vParentWindow;
    private boolean bMousePressed;

    public V2CMouseExitGlassPane(Window window) {
        this.vParentWindow = window;
        this.setOpaque(false);
    }

    void addToWindow() {
        V2CSwingUtil.setGlassPane(this.vParentWindow, this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
    }

    abstract void doExitAction(MouseEvent var1);

    private boolean isOutside(MouseEvent mouseEvent) {
        Point point;
        if (V2CApp.isMacintosh()) {
            point = V2CMacApplicationHandler.getMouseLocationOnScreen();
            SwingUtilities.convertPointFromScreen(point, this);
        } else {
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this);
        }
        Dimension dimension = this.getSize();
        return point.x <= 0 || point.y <= 0 || point.x >= dimension.width || point.y >= dimension.height;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Component component = mouseEvent.getComponent();
            if (component == null) {
                return;
            }
            if (!SwingUtilities.isDescendingFrom(component, this.vParentWindow)) {
                return;
            }
            switch (mouseEvent.getID()) {
                case 505: {
                    if (!this.bMousePressed && this.isOutside(mouseEvent) && !V2CPopupListener.isShowing()) {
                        this.doExitAction(mouseEvent);
                    }
                    return;
                }
                case 501: {
                    this.bMousePressed = true;
                    return;
                }
                case 502: {
                    this.bMousePressed = false;
                    return;
                }
            }
        }
    }

    public boolean contains(int n, int n2) {
        return false;
    }
}

