/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.im.InputContext;
import java.text.AttributedCharacterIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

abstract class V2CTextChangeListener
implements DocumentListener,
InputMethodListener {
    final JTextComponent jTextComponent;
    int nCommittedCharacterCount;
    int nCombinedCharacterCount;

    public V2CTextChangeListener(JTextComponent jTextComponent) {
        this.jTextComponent = jTextComponent;
        jTextComponent.addInputMethodListener(this);
        jTextComponent.getDocument().addDocumentListener(this);
    }

    boolean isComposing() {
        return this.nCommittedCharacterCount != this.nCombinedCharacterCount;
    }

    void endComposition() {
        InputContext inputContext;
        if (this.isComposing() && (inputContext = this.jTextComponent.getInputContext()) != null) {
            inputContext.endComposition();
        }
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        this.nCommittedCharacterCount = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        this.nCombinedCharacterCount = attributedCharacterIterator != null ? attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex() : 0;
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

