/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAbstractMiniSearch;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CAddressBar;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CImgDLStatus;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CMessageField;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMonochromeIconFactory;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProgressBar;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSearchHistoryItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadListHistory;
import org.monazilla.v2c.V2CThreadListPane;
import org.monazilla.v2c.V2CThreadViewHistory;
import org.monazilla.v2c.V2CThreadViewPane;
import org.monazilla.v2c.V2CToolBarButtonPanel;
import org.monazilla.v2c.V2CToolBarComponent;
import org.monazilla.v2c.V2CToolBarSP;
import org.monazilla.v2c.V2CToolBarSetting;
import org.monazilla.v2c.V2CWritePanel;
import org.monazilla.v2c.V2CWriteWindow;

public class V2CToolBar
extends JPanel {
    private static final String sSaveFileName = "toolbar.txt";
    private static final String sSaveFileName2 = "toolbar2.txt";
    static final String sComponentsFileName = "tbcmps.txt";
    static final String sConfKey = "ToolBar.Conf";
    static final String sMacConfKey = "ToolBar.MacConf";
    static final HashMap hmToolBars;
    static V2CToolBarSetting[] vlToolBarSetting;
    static V2CToolBarSetting[] vlClonedSetting;
    static boolean bSettingChecked;
    static final ArrayList alButtonPanels;
    static final boolean bMacUseSegmentedButton;
    static boolean bNoCustomBottonBorder;
    static int nDefaultIconSize;
    static final boolean bUseMonochromeIcon = false;
    String sID;

    static {
        V2CPackedPropValue v2cpackedpropvalue;
        hmToolBars = new HashMap();
        alButtonPanels = new ArrayList();
        V2CProperty v2cproperty = V2CApp.getUserProperty();
        if (V2CApp.isMacintosh()) {
            boolean flag = V2CApp.isMacintosh(5);
            boolean flag1 = V2CMacQuaquaSupport.isQuaquaInstalled();
            String s = v2cproperty.get(sMacConfKey);
            boolean flag2 = s == null || !s.equals("n");
            boolean bl = bMacUseSegmentedButton = flag && !flag1 && flag2;
            if (flag && !flag1 && !flag2) {
                UIManager.put("ToolBar.separatorSize", new DimensionUIResource(28, 2));
            }
        } else {
            bMacUseSegmentedButton = false;
        }
        if ((v2cpackedpropvalue = v2cproperty.getPackedValue(sConfKey)) != null) {
            bNoCustomBottonBorder = v2cpackedpropvalue.getBoolean('e');
            nDefaultIconSize = v2cpackedpropvalue.getIntInRangeIfExists('W', 12, 23);
        }
    }

    static boolean canMacUseSegmentedButton() {
        return V2CApp.isMacintosh(5) && !V2CMacQuaquaSupport.isQuaquaInstalled();
    }

    static boolean getMacUseSegmentedButtonSetting() {
        String s = V2CApp.getUserProperty().get(sMacConfKey);
        return s == null || !s.equals("n");
    }

    static void setMacUseSegmentedButtonSetting(boolean flag) {
        V2CProperty v2cproperty = V2CApp.getUserProperty();
        if (flag) {
            v2cproperty.remove(sMacConfKey);
        } else {
            v2cproperty.put(sMacConfKey, "n");
        }
    }

    static void updateAllUI(Container container) {
        for (V2CToolBar v2ctoolbar : hmToolBars.values()) {
            if (container != null && container != v2ctoolbar.getParent()) continue;
            V2CMain.fontForUIChanged0(v2ctoolbar);
        }
    }

    static ArrayList getButtonPanels() {
        return alButtonPanels;
    }

    public static V2CToolBarSP getToolBarConfPanel() {
        V2CToolBar.checkSetting();
        if (vlClonedSetting == null) {
            vlClonedSetting = V2CToolBarSetting.cloneArray(vlToolBarSetting);
        }
        V2CToolBarSetting[] av2ctoolbarsetting = V2CToolBarSetting.cloneArray(vlClonedSetting);
        V2CToolBarSetting[] av2ctoolbarsetting1 = V2CToolBar.restoreSetting(sComponentsFileName, false);
        if (av2ctoolbarsetting1 == null || av2ctoolbarsetting1.length != vlToolBarSetting.length) {
            return null;
        }
        V2CToolBarSP v2ctoolbarsp = new V2CToolBarSP(av2ctoolbarsetting1, av2ctoolbarsetting, !bNoCustomBottonBorder, nDefaultIconSize);
        return v2ctoolbarsp;
    }

    static void setToolBar() {
        V2CToolBarSP v2ctoolbarsp = V2CToolBar.getToolBarConfPanel();
        if (v2ctoolbarsp == null || !v2ctoolbarsp.showDialog()) {
            return;
        }
        V2CToolBar.applyToolbarSPChanges(v2ctoolbarsp);
    }

    static void applyToolbarSPChanges(V2CToolBarSP v2ctoolbarsp) {
        vlClonedSetting = v2ctoolbarsp.vlToolBarSetting;
        V2CToolBar.saveSetting();
        boolean flag = !v2ctoolbarsp.getDrawCustomBottonBorder();
        int i = v2ctoolbarsp.getIconWidth();
        bNoCustomBottonBorder = flag;
        nDefaultIconSize = i;
        V2CProperty v2cproperty = V2CApp.getUserProperty();
        if (flag || i > 0) {
            V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
            v2cpackedpropvalue.setBoolean('e', flag);
            if (i > 0) {
                v2cpackedpropvalue.setInt('W', i);
            }
            v2cproperty.putPackedValue(sConfKey, v2cpackedpropvalue);
        } else {
            v2cproperty.remove(sConfKey);
        }
        V2CSearchHistoryItem.setHistoryNum(v2ctoolbarsp);
    }

    static void restoreToolBar() {
        vlToolBarSetting = V2CToolBar.restoreSetting(sSaveFileName, true);
        int i = 0;
        while (i < vlToolBarSetting.length) {
            V2CToolBar.createToolBar(vlToolBarSetting[i], null);
            ++i;
        }
    }

    private static V2CToolBarSetting[] restoreSetting(String s, boolean flag) {
        ArrayList<V2CToolBarSetting> arraylist;
        block9: {
            BufferedReader bufferedreader;
            BufferedReader bufferedReader = bufferedreader = flag ? V2CLocalFileHandler.getUserSaveFileReader(s) : null;
            if (bufferedreader == null) {
                bufferedreader = V2CLocalFileHandler.getConfigReader(s);
            }
            if (bufferedreader == null) {
                System.out.println("cannot read " + s + " !");
                V2CApp.immediateExit(1);
                return null;
            }
            arraylist = new ArrayList<V2CToolBarSetting>();
            try {
                try {
                    String s1;
                    V2CToolBarSetting v2ctoolbarsetting = null;
                    while ((s1 = bufferedreader.readLine()) != null) {
                        if (s1.length() == 0 || s1.charAt(0) == '#') continue;
                        String[] as = V2CMiscUtil.split(s1);
                        int i = as.length;
                        String s2 = as[0];
                        if (s2.equals("ToolBar")) {
                            v2ctoolbarsetting = new V2CToolBarSetting(as);
                            arraylist.add(v2ctoolbarsetting);
                            continue;
                        }
                        if (v2ctoolbarsetting == null) continue;
                        v2ctoolbarsetting.add(as);
                    }
                }
                catch (IOException ioexception) {
                    System.out.println(ioexception.getMessage());
                    V2CApp.errorExit("\u30c4\u30fc\u30eb\u30d0\u30fc\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u30a8\u30e9\u30fc");
                    V2CLocalFileHandler.closeReader(bufferedreader);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                V2CLocalFileHandler.closeReader(bufferedreader);
                throw throwable;
            }
            V2CLocalFileHandler.closeReader(bufferedreader);
        }
        return arraylist.toArray(new V2CToolBarSetting[arraylist.size()]);
    }

    static void checkSetting() {
        int k;
        V2CToolBarSetting[] av2ctoolbarsetting1;
        if (bSettingChecked) {
            return;
        }
        bSettingChecked = true;
        V2CToolBarSetting[] av2ctoolbarsetting = vlToolBarSetting;
        int i = av2ctoolbarsetting.length;
        int j = 0;
        while (j < i) {
            V2CToolBarSetting v2ctoolbarsetting1 = av2ctoolbarsetting[j];
            if (v2ctoolbarsetting1.getIndex() == 3 && v2ctoolbarsetting1.getIDString().equals("Write")) {
                return;
            }
            ++j;
        }
        if (av2ctoolbarsetting[i - 2].getIDString().equals("Write")) {
            V2CToolBarSetting v2ctoolbarsetting = av2ctoolbarsetting[i - 1];
            av2ctoolbarsetting[i - 1] = av2ctoolbarsetting[i - 2];
            av2ctoolbarsetting[i - 2] = v2ctoolbarsetting;
        }
        if ((av2ctoolbarsetting1 = V2CToolBar.restoreSetting(sSaveFileName2, false)) != null && (k = av2ctoolbarsetting1.length) > 0) {
            V2CToolBarSetting[] av2ctoolbarsetting2 = new V2CToolBarSetting[i + k];
            System.arraycopy(av2ctoolbarsetting, 0, av2ctoolbarsetting2, 0, i);
            System.arraycopy(av2ctoolbarsetting1, 0, av2ctoolbarsetting2, i, k);
            vlToolBarSetting = av2ctoolbarsetting2;
        }
    }

    static void saveSetting() {
        if (vlClonedSetting == null) {
            return;
        }
        BufferedWriter bufferedwriter = V2CLocalFileHandler.getUserConfigWriter(sSaveFileName);
        if (bufferedwriter == null) {
            System.out.println("cannot write to toolbar.txt !");
            return;
        }
        try {
            try {
                int i = 0;
                while (i < vlClonedSetting.length) {
                    V2CToolBarSetting v2ctoolbarsetting = vlClonedSetting[i];
                    bufferedwriter.write("ToolBar,");
                    bufferedwriter.write(v2ctoolbarsetting.getIDString());
                    bufferedwriter.write(44);
                    bufferedwriter.write(v2ctoolbarsetting.getPositionString());
                    bufferedwriter.newLine();
                    int j = 0;
                    while (j < v2ctoolbarsetting.size()) {
                        V2CToolBarComponent v2ctoolbarcomponent = v2ctoolbarsetting.get(j);
                        String s = v2ctoolbarcomponent.getSaveString();
                        if (s != null) {
                            bufferedwriter.write(s);
                            bufferedwriter.newLine();
                        }
                        ++j;
                    }
                    bufferedwriter.newLine();
                    ++i;
                }
            }
            catch (IOException ioexception) {
                System.out.println(ioexception.getMessage());
                try {
                    bufferedwriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                bufferedwriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    static V2CToolBar getToolBar(String s, String s1) {
        return (V2CToolBar)hmToolBars.get(String.valueOf(s) + ':' + s1);
    }

    static boolean isToolBarVisible(String s, String s1) {
        V2CToolBar v2ctoolbar = V2CToolBar.getToolBar(s, s1);
        if (v2ctoolbar == null) {
            return true;
        }
        return v2ctoolbar.isVisible();
    }

    static boolean setToolBarVisible(String s, String s1, boolean flag) {
        int i;
        char[] ac;
        V2CToolBar v2ctoolbar = V2CToolBar.getToolBar(s, s1);
        if (v2ctoolbar == null) {
            return true;
        }
        v2ctoolbar.setVisible(flag);
        String s2 = String.valueOf(s) + ".ShowToolBar";
        V2CProperty v2cproperty = V2CMain.getUserProperty();
        String s3 = v2cproperty.get(s2);
        if (s3 == null || s3.length() != 4) {
            s3 = "SSSS";
        }
        if (flag != ((ac = s3.toCharArray())[i = V2CToolBarSetting.getToolBarPositionIndex(s1)] == 'S')) {
            ac[i] = flag ? 83 : 72;
            v2cproperty.put(s2, new String(ac));
        }
        return flag;
    }

    static void createToolBar(Container container, String s) {
        V2CToolBar.checkSetting();
        if (vlToolBarSetting == null) {
            return;
        }
        int i = 0;
        while (i < vlToolBarSetting.length) {
            V2CToolBarSetting v2ctoolbarsetting = vlToolBarSetting[i];
            if (s.equals(v2ctoolbarsetting.getIDString())) {
                V2CToolBar.createToolBar(v2ctoolbarsetting, container);
            }
            ++i;
        }
    }

    static void createToolBar(V2CToolBarSetting v2ctoolbarsetting, Container container) {
        String s1;
        String s = v2ctoolbarsetting.getIDString();
        if (container == null) {
            container = v2ctoolbarsetting.getContainer();
        }
        if (container == null) {
            return;
        }
        boolean flag = s.startsWith("Write");
        if (flag && v2ctoolbarsetting.size() == 0) {
            return;
        }
        V2CToolBar v2ctoolbar = new V2CToolBar(s, v2ctoolbarsetting, container);
        container.add((Component)v2ctoolbar, v2ctoolbarsetting.getBorderPosition());
        if (!flag && (s1 = V2CMain.getUserProperty().get(String.valueOf(s) + ".ShowToolBar")) != null && s1.length() == 4 && s1.charAt(v2ctoolbarsetting.getIndex()) != 'S') {
            v2ctoolbar.setVisible(false);
        }
    }

    static Component createToolBarButton(V2CAbstractAction v2cabstractaction, boolean flag) {
        String s;
        ToolBarButton toolbarbutton = null;
        switch (v2cabstractaction.getType()) {
            case 0: {
                toolbarbutton = new ToolBarButton(v2cabstractaction);
                break;
            }
            case 2: {
                toolbarbutton = new ToolBarButton(v2cabstractaction);
                if (!v2cabstractaction.isSelected()) break;
                toolbarbutton.setSelected(true);
            }
        }
        if (toolbarbutton == null) {
            return null;
        }
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(toolbarbutton);
            V2CMacQuaquaSupport.setSquareButtonStyle(toolbarbutton);
            toolbarbutton.setMargin(new Insets(2, 2, 2, 2));
        }
        toolbarbutton.setFocusable(false);
        if (flag) {
            v2cabstractaction.add(toolbarbutton);
        }
        if (!V2CToolBar.setCustomIcon(toolbarbutton, s = v2cabstractaction.getName())) {
            ImageIcon imageicon = null;
            if (bMacUseSegmentedButton) {
                V2CToolBar.checkSpecialIcon(s);
                toolbarbutton.putClientProperty("JComponent.sizeVariant", "small");
                int byte0 = 26;
                int byte1 = 18;
                toolbarbutton.putClientProperty("JButton.buttonType", "segmentedTextured");
                String s1 = null;
                if (v2cabstractaction instanceof V2CAction.DisplayPaneHistoryBack) {
                    s1 = "first";
                    byte0 = 20;
                } else if (v2cabstractaction instanceof V2CAction.DisplayPaneHistoryForward) {
                    s1 = "last";
                    byte0 = 20;
                } else {
                    s1 = "only";
                }
                toolbarbutton.putClientProperty("JButton.segmentPosition", s1);
                Dimension dimension = new Dimension(byte0, byte1);
                toolbarbutton.setPreferredSize(dimension);
                toolbarbutton.setMinimumSize(dimension);
                toolbarbutton.bMacSegmented = true;
                String s2 = v2cabstractaction.getIconName();
                imageicon = V2CMonochromeIconFactory.createIcon(s2, false);
                if (imageicon != null) {
                    toolbarbutton.setIcon(imageicon);
                    imageicon = V2CMonochromeIconFactory.createIcon(s2, true);
                    if (imageicon != null) {
                        toolbarbutton.setSelectedIcon(imageicon);
                    }
                }
            }
            if (imageicon == null && !V2CToolBar.setDefaultIcon(toolbarbutton, v2cabstractaction.getName())) {
                Icon icon = v2cabstractaction.getIcon();
                if (icon != null) {
                    toolbarbutton.setIcon(icon);
                    icon = v2cabstractaction.getDisabledIcon();
                    if (icon != null) {
                        toolbarbutton.setDisabledIcon(icon);
                    }
                } else {
                    toolbarbutton.setText(v2cabstractaction.getToolBarLabel());
                }
            }
        }
        toolbarbutton.setToolTipText(v2cabstractaction.getToolTipText());
        return toolbarbutton;
    }

    static boolean setDefaultIcon(ToolBarButton toolbarbutton, String s) {
        int j1;
        int[] ai1;
        int i1;
        int l;
        byte[] abyte0 = V2CLocalFileHandler.getIconBytesFromResource(s);
        if (abyte0 == null) {
            return false;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int i = abyte0.length;
        int byte0 = abyte0[0];
        int byte1 = abyte0[1];
        int j = abyte0[2] << 1;
        int[] ai = new int[byte0 * byte1];
        int k = nDefaultIconSize;
        boolean flag = k > 0 && k < byte0;
        boolean flag1 = V2CApp.isMacintosh();
        if (flag) {
            if (2 * k < byte0) {
                k = (byte0 + 1) / 2;
            }
            l = k;
            i1 = k;
            ai1 = new int[l * i1];
            j1 = (l << 15) / byte0;
        } else {
            l = byte0;
            i1 = byte1;
            ai1 = ai;
            j1 = 0;
        }
        int k1 = 3;
        int l1 = 0;
        while (l1 < 7) {
            if (((j >>>= 1) & 1) != 0) {
                if (flag1 && (j == 2 || j == 4)) {
                    k1 += 4 * byte0 * byte1;
                } else {
                    int i2 = 0;
                    int l2 = 0;
                    while (l2 < byte1) {
                        int j3 = 0;
                        while (j3 < byte0) {
                            ai[i2++] = (abyte0[k1++] & 0xFF) << 24 | (abyte0[k1++] & 0xFF) << 16 | (abyte0[k1++] & 0xFF) << 8 | abyte0[k1++] & 0xFF;
                            ++j3;
                        }
                        ++l2;
                    }
                    if (flag) {
                        int j2 = 0;
                        int i3 = ai.length;
                        int k3 = 0;
                        while (k3 < byte1) {
                            int i4 = k3 * byte0;
                            int k4 = 32768;
                            int i5 = 0;
                            int k5 = 0;
                            int i6 = 0;
                            int k6 = 0;
                            int i7 = 0;
                            while (i7 < byte0) {
                                int i8;
                                boolean flag3;
                                int k7 = ai[i4 + i7];
                                if (i7 == byte0 - 1) {
                                    k4 = j1;
                                }
                                boolean bl = flag3 = k4 <= j1;
                                if (flag3) {
                                    i8 = k4;
                                } else {
                                    i8 = j1;
                                    k4 -= j1;
                                }
                                int k8 = k7 >>> 24;
                                int i9 = i8 * k8;
                                k6 += i9;
                                i5 += (k7 >>> 16 & 0xFF) * i9;
                                k5 += (k7 >>> 8 & 0xFF) * i9;
                                i6 += (k7 & 0xFF) * i9;
                                if (flag3) {
                                    if (j2 >= i3) break;
                                    ai[j2++] = k6 != 0 ? (k6 & 0x7F8000) << 9 | i5 / k6 << 16 | k5 / k6 << 8 | i6 / k6 : 0;
                                    i8 = j1 - i8;
                                    k8 = k7 >>> 24;
                                    k6 = i9 = i8 * k8;
                                    i5 = (k7 >>> 16 & 0xFF) * i9;
                                    k5 = (k7 >>> 8 & 0xFF) * i9;
                                    i6 = (k7 & 0xFF) * i9;
                                    k4 = 32768 - i8;
                                }
                                ++i7;
                            }
                            ++k3;
                        }
                        i3 = ai1.length;
                        int l3 = 0;
                        while (l3 < l) {
                            int k2 = l3;
                            int j4 = 32768;
                            int l4 = 0;
                            int j5 = 0;
                            int l5 = 0;
                            int j6 = 0;
                            int l6 = 0;
                            while (l6 < byte1) {
                                int l7;
                                boolean flag2;
                                int j7 = ai[l6 * l + l3];
                                if (l6 == byte1 - 1) {
                                    j4 = j1;
                                }
                                boolean bl = flag2 = j4 <= j1;
                                if (flag2) {
                                    l7 = j4;
                                } else {
                                    l7 = j1;
                                    j4 -= j1;
                                }
                                int j8 = j7 >>> 24;
                                int l8 = l7 * j8;
                                j6 += l8;
                                l4 += (j7 >>> 16 & 0xFF) * l8;
                                j5 += (j7 >>> 8 & 0xFF) * l8;
                                l5 += (j7 & 0xFF) * l8;
                                if (flag2) {
                                    if (k2 >= i3) break;
                                    ai1[k2] = j6 != 0 ? (j6 & 0x7F8000) << 9 | l4 / j6 << 16 | j5 / j6 << 8 | l5 / j6 : 0;
                                    k2 += i1;
                                    l7 = j1 - l7;
                                    j8 = j7 >>> 24;
                                    j6 = l8 = l7 * j8;
                                    l4 = (j7 >>> 16 & 0xFF) * l8;
                                    j5 = (j7 >>> 8 & 0xFF) * l8;
                                    l5 = (j7 & 0xFF) * l8;
                                    j4 = 32768 - l7;
                                }
                                ++l6;
                            }
                            ++l3;
                        }
                    }
                    BufferedImage bufferedimage = new BufferedImage(l, i1, 2);
                    bufferedimage.setRGB(0, 0, l, i1, ai1, 0, l);
                    ImageIcon imageicon = new ImageIcon(bufferedimage);
                    switch (l1) {
                        case 0: {
                            toolbarbutton.setIcon(imageicon);
                            break;
                        }
                        case 1: {
                            toolbarbutton.setPressedIcon(imageicon);
                            break;
                        }
                        case 2: {
                            toolbarbutton.setRolloverIcon(imageicon);
                            break;
                        }
                        case 3: {
                            toolbarbutton.setSelectedIcon(imageicon);
                            break;
                        }
                        case 4: {
                            toolbarbutton.setRolloverSelectedIcon(imageicon);
                            break;
                        }
                        case 5: {
                            toolbarbutton.setDisabledIcon(imageicon);
                            break;
                        }
                        case 6: {
                            toolbarbutton.setDisabledSelectedIcon(imageicon);
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            ++l1;
        }
        toolbarbutton.setBorderPainted(false);
        toolbarbutton.setContentAreaFilled(false);
        toolbarbutton.setRolloverEnabled(true);
        Dimension dimension = new Dimension(l + 2, i1 + 2);
        toolbarbutton.setPreferredSize(dimension);
        toolbarbutton.setMinimumSize(dimension);
        V2CToolBar.checkSpecialIcon(s);
        toolbarbutton.bDefaultIcon = true;
        return true;
    }

    static JButton createButtonForToolBar(String s) {
        ToolBarButton toolbarbutton = new ToolBarButton();
        if (bMacUseSegmentedButton) {
            toolbarbutton.putClientProperty("JComponent.sizeVariant", "small");
            toolbarbutton.putClientProperty("JButton.buttonType", "segmentedTextured");
            toolbarbutton.putClientProperty("JButton.segmentPosition", "only");
        } else if (V2CApp.isMacintosh()) {
            toolbarbutton.setContentAreaFilled(false);
            toolbarbutton.setBorderPainted(false);
        }
        toolbarbutton.setMargin(bMacUseSegmentedButton ? new Insets(5, -7, 5, -7) : new Insets(1, 2, 1, 2));
        String s1 = "AddressBarOpen";
        if (!V2CToolBar.setCustomIcon(toolbarbutton, s1)) {
            ImageIcon imageicon = null;
            if (bMacUseSegmentedButton) {
                imageicon = V2CMonochromeIconFactory.createIcon(s, false);
            }
            if (imageicon == null && !V2CToolBar.setDefaultIcon(toolbarbutton, s1)) {
                imageicon = V2CSwingUtil.getSystemIcon(s);
            }
            if (imageicon != null) {
                toolbarbutton.setIcon(imageicon);
            }
        }
        return toolbarbutton;
    }

    static boolean setCustomIcon(AbstractButton abstractbutton, String s) {
        Icon icon = V2CToolBar.getCustomIcon(s);
        if (icon == null) {
            return false;
        }
        V2CToolBar.checkSpecialIcon(s);
        if (bNoCustomBottonBorder) {
            abstractbutton.setContentAreaFilled(false);
            abstractbutton.setBorderPainted(false);
        }
        abstractbutton.setIcon(icon);
        icon = V2CToolBar.getCustomIcon(String.valueOf(s) + "_P");
        if (icon != null) {
            abstractbutton.setPressedIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(String.valueOf(s) + "_S")) != null) {
            abstractbutton.setSelectedIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(String.valueOf(s) + "_R")) != null) {
            abstractbutton.setRolloverIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(String.valueOf(s) + "_RS")) != null) {
            abstractbutton.setRolloverSelectedIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(String.valueOf(s) + "_D")) != null) {
            abstractbutton.setDisabledIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(String.valueOf(s) + "_DS")) != null) {
            abstractbutton.setDisabledSelectedIcon(icon);
        }
        return true;
    }

    static Icon getCustomIcon(String s) {
        File file = V2CLocalFileHandler.getToolBarIconFile(s);
        if (file == null) {
            return null;
        }
        BufferedImage bufferedimage = null;
        try {
            bufferedimage = ImageIO.read(file);
        }
        catch (IOException ioexception) {
            System.out.println(ioexception.getMessage());
            return null;
        }
        if (bufferedimage == null) {
            return null;
        }
        return new ImageIcon(bufferedimage);
    }

    static void checkSpecialIcon(String s) {
        V2CThreadListPane.checkSpecialIcon(s);
        V2CThreadViewPane.checkSpecialIcon(s);
    }

    static Component createToolBarComponent(JToolBar jtoolbar, V2CToolBarComponent v2ctoolbarcomponent, String s, Container container) {
        Component obj = null;
        switch (v2ctoolbarcomponent.getType()) {
            default: {
                break;
            }
            case 2: {
                String s1 = v2ctoolbarcomponent.getComponentName();
                if (s1.equals("AddressBar")) {
                    obj = V2CAddressBar.getInstance();
                    break;
                }
                if (s1.equals("FindField")) break;
                if (s1.equals("BoardTreeMiniSearch")) {
                    obj = V2CAbstractMiniSearch.getInstance(0, true);
                    break;
                }
                if (s1.equals("ThreadListMiniSearch")) {
                    obj = V2CAbstractMiniSearch.getInstance(1, true);
                    break;
                }
                if (s1.equals("ThreadViewMiniSearch")) {
                    obj = V2CAbstractMiniSearch.getInstance(2, true);
                    break;
                }
                if (s1.equals("MessageField")) {
                    obj = V2CMessageField.getInstance();
                    break;
                }
                if (s1.equals("ImgDLStatus")) {
                    obj = V2CImgDLStatus.getInstance();
                    break;
                }
                if (s1.equals("ProgressBar")) {
                    obj = V2CProgressBar.getInstance();
                    break;
                }
                if (s1.equals("MemoryGauge")) {
                    obj = V2CMemoryGauge.getInstance();
                    break;
                }
                if (s1.equals("NameAndMail")) {
                    obj = ((V2CWritePanel)container).createNameAndMail();
                    break;
                }
                if (s1.equals("WritePanelWarning")) {
                    obj = ((V2CWriteWindow)container).createWarning();
                    break;
                }
                if (s1.equals("WritePanelCounter")) {
                    obj = ((V2CWritePanel)container).createCounter();
                    break;
                }
                if (s1.equals("WriteMessageStatus")) {
                    obj = ((V2CWritePanel)container).createWriteMessageStatus();
                    break;
                }
                if (s1.equals("MemoSelector")) {
                    obj = ((V2CWritePanel)container).createMemoSelector();
                    break;
                }
                if (s1.equals("ThreadViewHistory")) {
                    obj = V2CThreadViewHistory.createThreadViewHistory();
                    break;
                }
                if (s1.equals("ThreadListHistory")) {
                    obj = V2CThreadListHistory.createThreadListHistory();
                    break;
                }
                if (!s1.equals("ButtonPanel")) break;
                obj = V2CToolBarButtonPanel.getButtonPanel(s);
                alButtonPanels.add(obj);
                break;
            }
            case 3: {
                jtoolbar.addSeparator();
                break;
            }
            case 4: {
                obj = new ToolBarSpacer(v2ctoolbarcomponent.getWidth());
                break;
            }
            case 5: {
                obj = new ToolBarGlue();
            }
        }
        return obj;
    }

    public V2CToolBar(String s, V2CToolBarSetting v2ctoolbarsetting, Container container) {
        super(new GridBagLayout());
        this.sID = s;
        JToolBar jtoolbar = this.createNewToolBar(v2ctoolbarsetting.getToolBarOrientation());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.weightx = 1.0;
        this.add((Component)jtoolbar, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        String s1 = v2ctoolbarsetting.getPositionString();
        if (!s.startsWith("Write")) {
            hmToolBars.put(String.valueOf(s) + ':' + s1, this);
        }
        int i = 0;
        while (i < v2ctoolbarsetting.size()) {
            V2CToolBarComponent v2ctoolbarcomponent = v2ctoolbarsetting.get(i);
            Component component = null;
            int j = v2ctoolbarcomponent.getType();
            if (j == 6) {
                jtoolbar = this.createNewToolBar(v2ctoolbarsetting.getToolBarOrientation());
                ++gridbagconstraints.gridy;
                this.add((Component)jtoolbar, gridbagconstraints);
            } else {
                component = j == 1 ? V2CToolBar.createToolBarButton(v2ctoolbarcomponent.getAction(), true) : V2CToolBar.createToolBarComponent(jtoolbar, v2ctoolbarcomponent, this.sID, container);
                if (component != null) {
                    jtoolbar.add(component);
                }
            }
            ++i;
        }
        if (V2CApp.isMacintosh() && s.equals("Main") && s1.equals("Bottom")) {
            JPanel jpanel = new JPanel();
            jpanel.setOpaque(false);
            int byte0 = V2CApp.getOSXVersion() < 5 ? (int)(V2CApp.isBrushMetalLook() ? 20 : 13) : 8;
            Dimension dimension = new Dimension(byte0, 10);
            jpanel.setPreferredSize(dimension);
            jpanel.setMaximumSize(dimension);
            jtoolbar.add(jpanel);
        }
    }

    JToolBar createNewToolBar(int i) {
        SingleToolBar singletoolbar = new SingleToolBar(i);
        singletoolbar.setFloatable(false);
        return singletoolbar;
    }

    private static class SingleToolBar
    extends JToolBar {
        @Override
        public void updateUI() {
            super.updateUI();
            if (V2CSwingUtil.isSynthLaF()) {
                this.setLayout(new BoxLayout(this, 2));
            }
        }

        SingleToolBar(int i) {
            super(i);
        }
    }

    private static class ToolBarButton
    extends JButton {
        boolean bUIUpdated;
        boolean bDefaultIcon;
        boolean bMacSegmented;

        @Override
        public void setSelected(boolean flag) {
            if (!((V2CAbstractAction)this.getAction()).getName().equals("ToggleTreePane")) {
                super.setSelected(flag);
            }
        }

        @Override
        public void updateUI() {
            if (!this.bUIUpdated || !this.bMacSegmented) {
                this.bUIUpdated = true;
                super.updateUI();
            }
        }

        ToolBarButton() {
        }

        ToolBarButton(V2CAbstractAction v2cabstractaction) {
            super(v2cabstractaction);
        }
    }

    private static class ToolBarGlue
    extends JPanel {
        static Dimension dPref;
        static Dimension dMax;

        static {
            dMax = new Dimension(100000000, 10);
            Dimension dimension = UIManager.getDimension("ToolBar.separatorSize");
            dPref = new Dimension(dimension == null ? 5 : dimension.width, 10);
        }

        @Override
        public Dimension getPreferredSize() {
            return dPref;
        }

        @Override
        public Dimension getMaximumSize() {
            return dMax;
        }

        @Override
        public Dimension getMinimumSize() {
            return dPref;
        }

        ToolBarGlue() {
            this.setOpaque(false);
        }
    }

    private static class ToolBarSpacer
    extends JPanel {
        Dimension dSize;

        @Override
        public Dimension getPreferredSize() {
            return this.dSize;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.dSize;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dSize;
        }

        ToolBarSpacer(int i) {
            this.dSize = new Dimension(i, 10);
            this.setOpaque(false);
        }
    }
}

