/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CResStyle;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CTweetItem;
import org.monazilla.v2c.V2CTwitterUserID;

public class V2CTweetFilterItem {
    String sLabel;
    boolean bNotID;
    long[] llUserID;
    String[] slUserNames;
    boolean bNot;
    boolean bRegEx;
    boolean bCaseSens;
    boolean bAnd;
    boolean bOr;
    boolean bTextOnly;
    String sRawWord;
    String[] slWords;
    Pattern[] plWords;
    boolean bExRT;

    public V2CTweetFilterItem() {
        this.sLabel = "??";
        this.bCaseSens = true;
    }

    public V2CTweetFilterItem(V2CTweetFilterItem v2CTweetFilterItem) {
        Object[] objectArray;
        String[] stringArray;
        Object[] objectArray2;
        this.sLabel = v2CTweetFilterItem.sLabel;
        this.bNotID = v2CTweetFilterItem.bNotID;
        long[] lArray = v2CTweetFilterItem.llUserID;
        if (lArray != null) {
            objectArray2 = new long[lArray.length];
            System.arraycopy(lArray, 0, objectArray2, 0, lArray.length);
            this.llUserID = (long[])objectArray2;
        }
        if ((objectArray2 = v2CTweetFilterItem.slUserNames) != null) {
            stringArray = new String[objectArray2.length];
            System.arraycopy(objectArray2, 0, stringArray, 0, objectArray2.length);
            this.slUserNames = stringArray;
        }
        this.bRegEx = v2CTweetFilterItem.bRegEx;
        this.bCaseSens = v2CTweetFilterItem.bCaseSens;
        this.bAnd = v2CTweetFilterItem.bAnd;
        this.bOr = v2CTweetFilterItem.bOr;
        this.bTextOnly = v2CTweetFilterItem.bTextOnly;
        this.sRawWord = v2CTweetFilterItem.sRawWord;
        stringArray = v2CTweetFilterItem.slWords;
        if (stringArray != null) {
            objectArray = new String[stringArray.length];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            this.slWords = objectArray;
        }
        if ((objectArray = v2CTweetFilterItem.plWords) != null) {
            Pattern[] patternArray = new Pattern[objectArray.length];
            System.arraycopy(objectArray, 0, patternArray, 0, objectArray.length);
            this.plWords = patternArray;
        }
    }

    public V2CTweetFilterItem(V2CPackedPropValue v2CPackedPropValue) {
        boolean bl;
        if (v2CPackedPropValue == null) {
            return;
        }
        this.bNot = v2CPackedPropValue.getBoolean('!');
        String string = v2CPackedPropValue.getString('L');
        this.sLabel = string != null ? string : "??";
        this.restoreUsers(v2CPackedPropValue.getString('U'));
        this.bCaseSens = v2CPackedPropValue.getBoolean('C');
        this.bRegEx = v2CPackedPropValue.getBoolean('R');
        this.sRawWord = v2CPackedPropValue.getString('W');
        this.bAnd = bl = v2CPackedPropValue.getBoolean('a');
        this.bOr = !bl && v2CPackedPropValue.getBoolean('o');
        this.bTextOnly = v2CPackedPropValue.getBoolean('t');
        this.compileWord();
        this.bExRT = v2CPackedPropValue.getBoolean('r');
    }

    V2CPackedPropValue getSaveValue() {
        CharSequence charSequence;
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setString('L', this.sLabel);
        long[] lArray = this.llUserID;
        String[] stringArray = this.slUserNames;
        if (lArray != null && stringArray != null) {
            int n;
            charSequence = new StringBuffer();
            if (this.bNotID) {
                ((StringBuffer)charSequence).append('!');
            }
            int n2 = Math.min(lArray.length, stringArray.length);
            for (n = 0; n < n2; ++n) {
                long l = lArray[n];
                if (l <= 0L) continue;
                ((StringBuffer)charSequence).append(l);
                ((StringBuffer)charSequence).append(':');
                String string = stringArray[n];
                if (string != null) {
                    ((StringBuffer)charSequence).append(string);
                }
                ((StringBuffer)charSequence).append(';');
            }
            n = ((StringBuffer)charSequence).length();
            if (n > 0) {
                v2CPackedPropValue.setString('U', ((StringBuffer)charSequence).substring(0, n - 1));
            }
        }
        charSequence = this.sRawWord;
        String[] stringArray2 = this.slWords;
        Pattern[] patternArray = this.plWords;
        if (charSequence != null && (stringArray2 != null || patternArray != null)) {
            v2CPackedPropValue.setString('W', (String)charSequence);
            v2CPackedPropValue.setBoolean('!', this.bNot);
            v2CPackedPropValue.setBoolean('R', this.bRegEx);
            v2CPackedPropValue.setBoolean('C', this.bCaseSens);
            v2CPackedPropValue.setBoolean('a', this.bAnd);
            v2CPackedPropValue.setBoolean('o', this.bOr);
            v2CPackedPropValue.setBoolean('t', this.bTextOnly);
        }
        v2CPackedPropValue.setBoolean('r', this.bExRT);
        return v2CPackedPropValue;
    }

    private void restoreUsers(String string) {
        String[] stringArray;
        if (string == null || string.length() < 2) {
            return;
        }
        if (string.charAt(0) == '!') {
            this.bNotID = true;
            string = string.substring(1);
        }
        if ((stringArray = V2CMiscUtil.split(string, ';', true)) == null) {
            return;
        }
        int n = stringArray.length;
        long[] lArray = new long[n];
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            int n2 = string2.indexOf(58);
            if (n2 <= 0) continue;
            lArray[i] = V2CMiscUtil.parseLong(string2, 0, n2, 0L);
            stringArray2[i] = string2.substring(n2 + 1);
        }
        this.llUserID = lArray;
        this.slUserNames = stringArray2;
    }

    private boolean compileWord() {
        this.plWords = null;
        this.slWords = null;
        String string = this.sRawWord;
        if (string == null) {
            return true;
        }
        if (string.length() == 0) {
            this.sRawWord = null;
            return true;
        }
        String[] stringArray = V2CMiscUtil.turnStringToArray(string, this.bAnd || this.bOr);
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        int n = stringArray.length;
        if (this.bRegEx) {
            Pattern[] patternArray = new Pattern[n];
            int n2 = this.bCaseSens ? 0 : 2;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                try {
                    patternArray[i] = Pattern.compile(string2, n2);
                    continue;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    V2CSwingUtil.showErrorMessage("\u6b63\u898f\u8868\u73fe\u6587\u6cd5\u30a8\u30e9\u30fc");
                    return false;
                }
            }
            this.plWords = patternArray;
        } else {
            if (!this.bCaseSens) {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = V2CMiscUtil.normalizeCase(stringArray[i]);
                }
            }
            this.slWords = stringArray;
        }
        return true;
    }

    boolean setParms(String string, V2CTwitterUserID[] v2CTwitterUserIDArray, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        int n;
        block14: {
            boolean bl9;
            boolean bl10;
            boolean bl11;
            boolean bl12;
            boolean bl13;
            boolean bl14;
            String[] stringArray;
            Pattern[] patternArray;
            String string3;
            block13: {
                if (string2 == null || string2.length() == 0) {
                    string2 = null;
                }
                if (bl5 && bl6) {
                    bl6 = false;
                }
                string3 = this.sRawWord;
                patternArray = this.plWords;
                stringArray = this.slWords;
                bl14 = this.bNot;
                bl13 = this.bRegEx;
                bl12 = this.bCaseSens;
                bl11 = this.bAnd;
                bl10 = this.bOr;
                bl9 = this.bTextOnly;
                if (string2 == null ? string3 != null : !string2.equals(string3)) break block13;
                if (bl2 == bl14 && bl3 == bl13 && bl4 == bl12 && bl5 == bl11 && bl6 == bl10 && bl7 == bl9) break block14;
            }
            this.sRawWord = string2;
            this.bNot = bl2;
            this.bRegEx = bl3;
            this.bCaseSens = bl4;
            this.bAnd = bl5;
            this.bOr = !bl5 && bl6;
            this.bTextOnly = bl7;
            n = 0;
            try {
                n = this.compileWord() ? 1 : 0;
            }
            catch (Exception exception) {
                n = 0;
            }
            if (n == 0) {
                this.sRawWord = string3;
                this.plWords = patternArray;
                this.slWords = stringArray;
                this.bNot = bl14;
                this.bRegEx = bl13;
                this.bCaseSens = bl12;
                this.bAnd = bl11;
                this.bOr = bl10;
                this.bTextOnly = bl9;
                return false;
            }
        }
        if (!string.equals(this.sLabel)) {
            this.sLabel = string;
        }
        if (v2CTwitterUserIDArray != null) {
            n = v2CTwitterUserIDArray.length;
            if (n > 0) {
                long[] lArray = new long[n];
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    V2CTwitterUserID v2CTwitterUserID = v2CTwitterUserIDArray[i];
                    lArray[i] = v2CTwitterUserID.getID();
                    stringArray[i] = v2CTwitterUserID.getUserName();
                }
                this.llUserID = lArray;
                this.slUserNames = stringArray;
            } else {
                this.llUserID = null;
                this.slUserNames = null;
            }
        }
        if (bl != this.bNotID) {
            this.bNotID = bl;
        }
        if (bl8 != this.bExRT) {
            this.bExRT = bl8;
        }
        return true;
    }

    void toggleUser(V2CTwitterUserID v2CTwitterUserID, boolean n) {
        int n2;
        int n3;
        long l = v2CTwitterUserID.getID();
        long[] lArray = this.llUserID;
        String[] stringArray = this.slUserNames;
        if (lArray == null || stringArray == null) {
            if (n != 0) {
                this.llUserID = new long[]{l};
                this.slUserNames = new String[]{v2CTwitterUserID.getUserName()};
            }
            return;
        }
        int n4 = lArray.length;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList.add(new Long(lArray[n3]));
            arrayList2.add(stringArray[n3]);
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (lArray[n2] != l) continue;
            n3 = 1;
            arrayList.remove(n2);
            arrayList2.remove(n2);
            break;
        }
        if (n == n3) {
            return;
        }
        if (n3 != 0) {
            if (arrayList.size() == 0) {
                this.llUserID = null;
                this.slUserNames = null;
                return;
            }
        } else {
            arrayList.add(new Long(l));
            arrayList2.add(v2CTwitterUserID.getUserName());
        }
        n4 = arrayList.size();
        lArray = new long[n4];
        stringArray = new String[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            lArray[n2] = (Long)arrayList.get(n2);
            stringArray[n2] = (String)arrayList2.get(n2);
        }
        this.llUserID = lArray;
        this.slUserNames = stringArray;
    }

    V2CTwitterUserID[] createUserIDArray() {
        long[] lArray = this.llUserID;
        String[] stringArray = this.slUserNames;
        if (lArray == null || stringArray == null) {
            return new V2CTwitterUserID[0];
        }
        ArrayList<V2CTwitterUserID> arrayList = new ArrayList<V2CTwitterUserID>();
        int n = Math.min(lArray.length, stringArray.length);
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            if (l <= 0L) continue;
            arrayList.add(new V2CTwitterUserID(l, stringArray[i], true));
        }
        n = arrayList.size();
        Object[] objectArray = arrayList.toArray(new V2CTwitterUserID[n]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    boolean contains(long l) {
        long[] lArray = this.llUserID;
        if (lArray == null) {
            return false;
        }
        for (int i = lArray.length - 1; i >= 0; --i) {
            if (l != lArray[i]) continue;
            return true;
        }
        return false;
    }

    boolean check(V2CTweetItem v2CTweetItem, V2CThreadPanel v2CThreadPanel) {
        int n;
        if (this.bExRT && v2CTweetItem.isRetweet()) {
            return false;
        }
        long[] lArray = this.llUserID;
        if (lArray != null) {
            boolean bl = false;
            long l = v2CTweetItem.getOwnerUserID();
            if (l > 0L) {
                for (n = lArray.length - 1; n >= 0; --n) {
                    long l2 = lArray[n];
                    if (l2 != l) continue;
                    bl = true;
                    break;
                }
            }
            if (!(this.bNotID ^ bl)) {
                return false;
            }
        }
        Pattern[] patternArray = this.plWords;
        String[] stringArray = this.slWords;
        boolean bl = this.bRegEx;
        if (bl ? patternArray != null : stringArray != null) {
            String string;
            n = bl ? patternArray.length : stringArray.length;
            boolean bl2 = this.bCaseSens;
            boolean bl3 = this.bAnd;
            boolean bl4 = this.bOr;
            boolean bl5 = this.bTextOnly;
            if (bl5) {
                string = ((Object)v2CTweetItem.getMessage()).toString();
            } else {
                V2CResStyle v2CResStyle = v2CThreadPanel.getResStyle(v2CTweetItem);
                string = v2CResStyle.getString(v2CTweetItem, v2CThreadPanel.vtiThreadItem);
            }
            if (!bl && !bl2) {
                string = V2CMiscUtil.normalizeCase(string);
            }
            boolean bl6 = false;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    Matcher matcher = patternArray[i].matcher(string);
                    bl6 = matcher.find();
                } else {
                    boolean bl7 = bl6 = string.indexOf(stringArray[i]) >= 0;
                }
                if (bl3 ? !bl6 : bl4 && bl6) break;
            }
            if (!(this.bNot ^ bl6)) {
                return false;
            }
        }
        return true;
    }

    String getLabel() {
        return this.sLabel;
    }

    String getRawWord() {
        return this.sRawWord;
    }

    boolean isNot() {
        return this.bNot;
    }

    boolean isRegEx() {
        return this.bRegEx;
    }

    boolean isCaseSens() {
        return this.bCaseSens;
    }

    boolean isAnd() {
        return this.bAnd;
    }

    boolean isOr() {
        return this.bOr;
    }

    boolean isTextOnly() {
        return this.bTextOnly;
    }

    boolean isExRT() {
        return this.bExRT;
    }

    boolean getHideSelectedUsers() {
        return this.bNotID;
    }

    public String toString() {
        return this.sLabel;
    }
}

