/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.swing.Timer;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CJSONUtil;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTwitterBBS;
import org.monazilla.v2c.V2CTwitterConstants;
import org.monazilla.v2c.V2CTwitterListItem;
import org.monazilla.v2c.V2CTwitterThreadRes;
import org.monazilla.v2c.V2CTwitterUserStream;

public class V2CTwitterUser
implements V2CTwitterConstants {
    private static final String sVerifyCredFileName = "verify_credentials.json";
    private static final String sSettingsFileName = "settings.json";
    private static final String sFriendsFileName = "friends.bin";
    private static final String sFollowersFileName = "followers.bin";
    private static final String sNoRetweetFileName = "noretweet.bin";
    private static final String sBlockingFileName = "blocking.bin";
    private static final String sUserKey = "Twitter.User:";
    private static final ArrayList alTwitterUsers = new ArrayList();
    private static boolean bUsersRestored;
    private static boolean bPasswordSet;
    private static V2CTwitterUser[] vMentionBGUsers;
    private long nID;
    private String sUserName;
    private String sFullName;
    private String sURL;
    private String sLocation;
    private String sDescription;
    private String sOAuthAccessToken;
    private String sOAuthAccessTokenSecret;
    private String sOAAccessLevel;
    private boolean bValid;
    private String sProfileImageURL;
    private boolean bInfoCacheLoaded;
    private boolean bSettingsLoaded;
    private Color cMentionBG;
    private Color cWritePanelBG;
    private boolean bDontUseDM;
    private boolean bUserStream;
    private boolean bFilterStream;
    private int nUTCOffset;
    private boolean bProtected;
    private boolean bAlwaysUseHTTPS;
    private final long[][] nlIDs = new long[4][];
    private Timer vUpdateUserInfoTimer;
    private final HashMap vRateLimitMap = new HashMap();
    long ltServerDate;
    boolean bInfoUpdated;
    static final int RL_REMAIN = 0;
    static final int RL_RESET = 1;
    static final int RL_LIMIT = 2;
    private long ltLastInfoUpdate;
    private int iUserInfoUpdateCount;
    private boolean bDMForbiddenWarned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CTwitterUser[] getUsers() {
        ArrayList arrayList;
        V2CTwitterUser.restoreUsers();
        ArrayList arrayList2 = arrayList = alTwitterUsers;
        synchronized (arrayList2) {
            return arrayList.toArray(new V2CTwitterUser[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CTwitterUser[] getMentionBGUsers() {
        V2CTwitterUser.restoreUsers();
        V2CTwitterUser[] v2CTwitterUserArray = vMentionBGUsers;
        if (v2CTwitterUserArray != null) {
            return v2CTwitterUserArray;
        }
        ArrayList arrayList = alTwitterUsers;
        ArrayList<V2CTwitterUser> arrayList2 = new ArrayList<V2CTwitterUser>();
        ArrayList arrayList3 = arrayList;
        synchronized (arrayList3) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                V2CTwitterUser v2CTwitterUser = (V2CTwitterUser)arrayList.get(i);
                if (v2CTwitterUser.getMentionBG() == null) continue;
                arrayList2.add(v2CTwitterUser);
            }
        }
        v2CTwitterUserArray = arrayList2.toArray(new V2CTwitterUser[arrayList2.size()]);
        vMentionBGUsers = v2CTwitterUserArray;
        return v2CTwitterUserArray;
    }

    static int getUsersCount() {
        V2CTwitterUser.restoreUsers();
        return alTwitterUsers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int guessUTCOffset() {
        ArrayList arrayList;
        V2CTwitterUser.restoreUsers();
        Cloneable cloneable = arrayList = alTwitterUsers;
        synchronized (cloneable) {
            if (arrayList.size() > 0) {
                V2CTwitterUser v2CTwitterUser = (V2CTwitterUser)arrayList.get(0);
                v2CTwitterUser.loadInfoCache();
                return v2CTwitterUser.nUTCOffset * 1000;
            }
        }
        cloneable = TimeZone.getDefault();
        if (cloneable == null) {
            cloneable = V2CBBS.tzWritePreview;
        }
        return ((TimeZone)cloneable).getRawOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreUsers() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alTwitterUsers;
        synchronized (arrayList2) {
            if (bUsersRestored) {
                return;
            }
            bUsersRestored = true;
            V2CProperty v2CProperty = V2CBBS.getTwitterBBS().getProperty();
            V2CPackedPropValue[] v2CPackedPropValueArray = v2CProperty.getPackedValueArray(sUserKey);
            if (v2CPackedPropValueArray != null) {
                for (int i = 0; i < v2CPackedPropValueArray.length; ++i) {
                    V2CTwitterUser v2CTwitterUser = new V2CTwitterUser(v2CPackedPropValueArray[i]);
                    if (!v2CTwitterUser.isOK()) continue;
                    arrayList.add(v2CTwitterUser);
                }
            }
        }
        if (bPasswordSet) {
            V2CTwitterUser.saveUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveUsers() {
        ArrayList arrayList;
        vMentionBGUsers = null;
        ArrayList<V2CPackedPropValue> arrayList2 = new ArrayList<V2CPackedPropValue>();
        ArrayList arrayList3 = arrayList = alTwitterUsers;
        synchronized (arrayList3) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                V2CPackedPropValue v2CPackedPropValue = ((V2CTwitterUser)arrayList.get(i)).getSaveValue();
                if (v2CPackedPropValue == null) continue;
                arrayList2.add(v2CPackedPropValue);
            }
        }
        V2CBBS.getTwitterBBS().getProperty().putPackedValueArray(sUserKey, arrayList2.toArray(new V2CPackedPropValue[arrayList2.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultUser(V2CTwitterUser v2CTwitterUser) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alTwitterUsers;
        synchronized (arrayList2) {
            int n = arrayList.indexOf(v2CTwitterUser);
            if (n > 0) {
                arrayList.remove(v2CTwitterUser);
                arrayList.add(0, v2CTwitterUser);
                V2CTwitterUser.saveUsers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteUser(V2CTwitterUser v2CTwitterUser) {
        ArrayList arrayList;
        if (v2CTwitterUser == null) {
            return;
        }
        ArrayList arrayList2 = arrayList = alTwitterUsers;
        synchronized (arrayList2) {
            arrayList.remove(v2CTwitterUser);
            V2CTwitterUser.saveUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUser(V2CTwitterUser v2CTwitterUser) {
        ArrayList arrayList;
        if (!v2CTwitterUser.isOK()) {
            return;
        }
        String string = v2CTwitterUser.getUserName();
        long l = v2CTwitterUser.getID();
        V2CTwitterUser.restoreUsers();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = arrayList = alTwitterUsers;
        synchronized (arrayList3) {
            int n = arrayList.size();
            for (int i = n - 1; i >= 0; --i) {
                V2CTwitterUser v2CTwitterUser2 = (V2CTwitterUser)arrayList.get(i);
                if (!string.equals(v2CTwitterUser2.getUserName()) && l != v2CTwitterUser2.getID()) continue;
                arrayList.remove(i);
            }
            arrayList.add(v2CTwitterUser);
            V2CTwitterUser.saveUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getUserIndex(long l) {
        if (l > 0L) {
            ArrayList arrayList;
            V2CTwitterUser.restoreUsers();
            ArrayList arrayList2 = arrayList = alTwitterUsers;
            synchronized (arrayList2) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    V2CTwitterUser v2CTwitterUser = (V2CTwitterUser)arrayList.get(i);
                    if (l != v2CTwitterUser.getID()) continue;
                    return i;
                }
            }
        }
        return 0x3FFFFFFF;
    }

    static V2CTwitterUser getUser(long l) {
        return V2CTwitterUser.getUser(l, null);
    }

    static V2CTwitterUser getUser(String string) {
        return V2CTwitterUser.getUser(0L, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CTwitterUser getUser(long l, String string) {
        ArrayList arrayList;
        if (l <= 0L && string == null) {
            return null;
        }
        V2CTwitterUser.restoreUsers();
        ArrayList arrayList2 = arrayList = alTwitterUsers;
        synchronized (arrayList2) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                V2CTwitterUser v2CTwitterUser = (V2CTwitterUser)arrayList.get(i);
                if (l > 0L && l != v2CTwitterUser.getID() || string != null && !string.equals(v2CTwitterUser.getUserName())) continue;
                return v2CTwitterUser;
            }
        }
        return null;
    }

    static V2CTwitterUser getSingleUser(V2CTwitterUser v2CTwitterUser) {
        Object[] objectArray = V2CTwitterUser.getUsers();
        if (objectArray.length == 0) {
            return null;
        }
        if (objectArray.length == 1) {
            return objectArray[0];
        }
        return (V2CTwitterUser)V2CSwingUtil.showComboBoxDialog(objectArray, (Object)v2CTwitterUser, "\u30e6\u30fc\u30b6\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "Twitter\u30e6\u30fc\u30b6\u9078\u629e");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CTwitterUser getDefaultUser() {
        ArrayList arrayList;
        V2CTwitterUser.restoreUsers();
        ArrayList arrayList2 = arrayList = alTwitterUsers;
        synchronized (arrayList2) {
            if (arrayList.size() > 0) {
                return (V2CTwitterUser)arrayList.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CTwitterUser getUserFollowing(long l) {
        ArrayList arrayList;
        V2CTwitterUser.restoreUsers();
        ArrayList arrayList2 = arrayList = alTwitterUsers;
        synchronized (arrayList2) {
            for (int i = arrayList.size() - 1; i > 0; --i) {
                V2CTwitterUser v2CTwitterUser = (V2CTwitterUser)arrayList.get(i);
                if (!v2CTwitterUser.isOK() || !v2CTwitterUser.isFollowing(l)) continue;
                return v2CTwitterUser;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getAuthUser(long l) {
        ArrayList<String> arrayList;
        if (V2CTwitterUser.getUsersCount() <= 0) {
            return null;
        }
        ArrayList arrayList2 = alTwitterUsers;
        Object object = arrayList2;
        synchronized (object) {
            arrayList = new ArrayList<String>(arrayList2);
        }
        arrayList.add(0, "\uff08\u306a\u3057\uff09");
        object = null;
        for (int i = arrayList.size() - 1; i > 0; --i) {
            V2CTwitterUser v2CTwitterUser = (V2CTwitterUser)arrayList.get(i);
            if (v2CTwitterUser.getID() != l) continue;
            object = v2CTwitterUser;
            break;
        }
        return V2CSwingUtil.showComboBoxDialog(arrayList.toArray(), object, "UserTimeLine\u53d6\u5f97\u6642\u306b\u4f7f\u7528\u3059\u308b\u30a2\u30ab\u30a6\u30f3\u30c8", "Twitter\u30a2\u30ab\u30a6\u30f3\u30c8\u9078\u629e");
    }

    static boolean checkID(String string) {
        return string != null && Pattern.matches("\\w+", string);
    }

    static boolean checkPW(String string) {
        return string != null && string.length() >= 4;
    }

    public V2CTwitterUser(String string) {
        boolean bl = V2CTwitterUser.checkID(string);
        this.sUserName = bl ? string : null;
        this.bValid = bl;
    }

    public V2CTwitterUser(long l) {
        this.nID = l;
    }

    private V2CTwitterUser(V2CPackedPropValue v2CPackedPropValue) {
        if (v2CPackedPropValue != null) {
            this.nID = v2CPackedPropValue.getLong('I');
            this.sUserName = V2CMiscUtil.getBase64String(v2CPackedPropValue, 'U');
            if (v2CPackedPropValue.getString('P') != null) {
                bPasswordSet = true;
            }
            this.sOAuthAccessToken = V2CMiscUtil.getBase64String(v2CPackedPropValue, 'T');
            this.sOAuthAccessTokenSecret = V2CMiscUtil.getBase64String(v2CPackedPropValue, 'S');
            this.sOAAccessLevel = v2CPackedPropValue.getString('L');
            V2CHttpUtil.addSecretKeySpec(this.sOAuthAccessTokenSecret);
            this.cMentionBG = v2CPackedPropValue.getColor('R');
            this.cWritePanelBG = v2CPackedPropValue.getColor('B');
            this.bDontUseDM = v2CPackedPropValue.getBoolean('D');
            this.bUserStream = v2CPackedPropValue.getBoolean('M');
            this.bFilterStream = v2CPackedPropValue.getBoolean('F');
        }
        this.bValid = V2CTwitterUser.checkID(this.sUserName) && this.sOAuthAccessToken != null && this.sOAuthAccessTokenSecret != null;
    }

    boolean setOAuthAccessTokens(long l, String string, String string2, String string3, String string4) {
        if (l <= 0L || string == null || string2 == null || string3 == null) {
            return false;
        }
        this.nID = l;
        this.sUserName = string;
        this.sOAuthAccessToken = string2;
        this.sOAuthAccessTokenSecret = string3;
        V2CHttpUtil.addSecretKeySpec(string3);
        this.bValid = V2CTwitterUser.checkID(string);
        return true;
    }

    String getOAuthAccessToken() {
        return this.sOAuthAccessToken;
    }

    String getOAuthAccessTokenSecret() {
        return this.sOAuthAccessTokenSecret;
    }

    boolean setUserInfo(byte[] byArray) {
        Object v;
        Object object;
        try {
            object = V2CJSONUtil.parse(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        this.bInfoCacheLoaded = true;
        Map map = (Map)object;
        Object v2 = map.get("screen_name");
        if (!(v2 instanceof String)) {
            return false;
        }
        if (!v2.equals(this.sUserName)) {
            this.sUserName = (String)v2;
            V2CTwitterUser.saveUsers();
        }
        if ((v = map.get("id")) instanceof Number) {
            this.nID = ((Number)v).longValue();
        }
        this.getUserInfo((Map)object);
        File file = this.getUserFile(sVerifyCredFileName);
        if (file != null) {
            V2CLocalFileHandler.saveToFile(file, byArray);
        }
        return true;
    }

    private void getUserInfo(Map map) {
        Object v;
        Object v2;
        Object v3;
        Object v4;
        Object v5;
        Object v6;
        Object v7 = map.get("name");
        if (v7 instanceof String) {
            this.sFullName = (String)v7;
        }
        if ((v6 = map.get("description")) == null || v6 instanceof String) {
            this.sDescription = (String)v6;
        }
        if ((v5 = map.get("url")) == null || v5 instanceof String) {
            this.sURL = (String)v5;
        }
        if ((v4 = map.get("location")) == null || v4 instanceof String) {
            this.sLocation = (String)v4;
        }
        if ((v3 = map.get("profile_image_url")) instanceof String) {
            this.sProfileImageURL = (String)v3;
        }
        if ((v2 = map.get("utc_offset")) instanceof Number) {
            this.nUTCOffset = ((Number)v2).intValue();
        }
        if ((v = map.get("protected")) instanceof Boolean) {
            this.bProtected = (Boolean)v;
        }
    }

    void loadInfoCache() {
        Object object;
        if (this.bInfoCacheLoaded) {
            return;
        }
        this.bInfoCacheLoaded = true;
        File file = this.getUserFile(sVerifyCredFileName);
        if (file == null) {
            return;
        }
        byte[] byArray = V2CLocalFileHandler.restoreBytesFromFile(file);
        try {
            object = V2CJSONUtil.parse(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (!(object instanceof Map)) {
            return;
        }
        this.getUserInfo((Map)object);
    }

    boolean setUserSetting(byte[] byArray) {
        File file;
        Object object;
        try {
            object = V2CJSONUtil.parse(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        this.bSettingsLoaded = true;
        Map map = (Map)object;
        Object v = map.get("always_use_https");
        if (v instanceof Boolean) {
            this.bAlwaysUseHTTPS = (Boolean)v;
        }
        if ((file = this.getUserFile(sSettingsFileName)) != null) {
            V2CLocalFileHandler.saveToFile(file, byArray);
        }
        return true;
    }

    void loadSettingsCache() {
        Object object;
        if (this.bSettingsLoaded) {
            return;
        }
        this.bSettingsLoaded = true;
        File file = this.getUserFile(sSettingsFileName);
        if (file == null) {
            return;
        }
        byte[] byArray = V2CLocalFileHandler.restoreBytesFromFile(file);
        try {
            object = V2CJSONUtil.parse(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (!(object instanceof Map)) {
            return;
        }
        Map map = (Map)object;
        Object v = map.get("always_use_https");
        if (v instanceof Boolean) {
            this.bAlwaysUseHTTPS = (Boolean)v;
        }
    }

    File getUserFile(String string) {
        return V2CTwitterBBS.getUserFile(this.nID, string);
    }

    private void restoreLists(ArrayList arrayList, boolean bl) {
        File file = this.getUserFile(bl ? "lists.json" : "lists_subscriptions.json");
        if (file == null) {
            return;
        }
        byte[] byArray = V2CLocalFileHandler.restoreBytesFromFile(file);
        if (byArray == null) {
            return;
        }
        Object object = null;
        try {
            object = V2CJSONUtil.parse(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return;
        }
        if (!(object instanceof Map)) {
            return;
        }
        Object v = ((Map)object).get("lists");
        if (!(v instanceof List)) {
            return;
        }
        List list = (List)v;
        for (int i = list.size() - 1; i >= 0; --i) {
            V2CTwitterListItem v2CTwitterListItem;
            Object e = list.get(i);
            if (!(e instanceof Map) || (v2CTwitterListItem = V2CTwitterListItem.createItem((Map)e, bl)) == null) continue;
            arrayList.add(v2CTwitterListItem);
        }
    }

    private ArrayList restoreLists(boolean bl) {
        File file = this.getUserFile("lists_list.json");
        if (file == null) {
            return null;
        }
        byte[] byArray = V2CLocalFileHandler.restoreBytesFromFile(file);
        if (byArray == null) {
            return null;
        }
        Object object = null;
        try {
            object = V2CJSONUtil.parse(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
        if (!(object instanceof List)) {
            return null;
        }
        List list = (List)object;
        ArrayList<V2CTwitterListItem> arrayList = new ArrayList<V2CTwitterListItem>();
        for (int i = list.size() - 1; i >= 0; --i) {
            V2CTwitterListItem v2CTwitterListItem;
            boolean bl2;
            long l;
            Map map;
            Object v;
            Object e = list.get(i);
            if (!(e instanceof Map) || !((v = (map = (Map)e).get("user")) instanceof Map) || (l = V2CTwitterThreadRes.getLongFromMap(v, "id")) <= 0L) continue;
            boolean bl3 = bl2 = l == this.nID;
            if (!bl && !bl2 || (v2CTwitterListItem = V2CTwitterListItem.createItem(map, bl2)) == null) continue;
            arrayList.add(v2CTwitterListItem);
        }
        return arrayList;
    }

    ArrayList getLists(boolean bl) {
        ArrayList arrayList = this.restoreLists(bl);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.restoreLists(arrayList, true);
            if (bl) {
                this.restoreLists(arrayList, false);
            }
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    V2CTwitterListItem getList(long l) {
        if (l <= 0L) {
            return null;
        }
        ArrayList arrayList = this.getLists(true);
        if (arrayList == null) {
            return null;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            V2CTwitterListItem v2CTwitterListItem = (V2CTwitterListItem)arrayList.get(i);
            if (l != v2CTwitterListItem.getID()) continue;
            return v2CTwitterListItem;
        }
        return null;
    }

    boolean hasValidNameAndPassword() {
        return this.bValid;
    }

    boolean isOK() {
        return this.bValid && this.nID > 0L;
    }

    long getID() {
        return this.nID;
    }

    void setID(int n) {
        this.nID = n;
    }

    String getUserName() {
        return this.sUserName;
    }

    String getFullName() {
        this.loadInfoCache();
        return this.sFullName;
    }

    String getProfileImageURL() {
        this.loadInfoCache();
        return this.sProfileImageURL;
    }

    boolean isProtected() {
        this.loadInfoCache();
        return this.bProtected;
    }

    String getLocation() {
        this.loadInfoCache();
        return this.sLocation;
    }

    String getURL() {
        this.loadInfoCache();
        return this.sURL;
    }

    String getDescription() {
        this.loadInfoCache();
        return this.sDescription;
    }

    boolean getAlwaysUseHTTPS() {
        this.loadSettingsCache();
        return this.bAlwaysUseHTTPS;
    }

    Color getMentionBG() {
        return this.cMentionBG;
    }

    Color getWritePanelBG() {
        return this.cWritePanelBG;
    }

    void setWritePanelBG(boolean bl, boolean bl2, boolean bl3, Color color, Color color2) {
        this.bDontUseDM = bl;
        boolean bl4 = this.bUserStream;
        this.bUserStream = bl2;
        this.bFilterStream = bl3;
        this.cMentionBG = color;
        this.cWritePanelBG = color2;
        V2CTwitterUser.saveUsers();
        if (bl2 != bl4) {
            V2CTwitterUserStream.changeUserStream(this, bl2);
        }
    }

    boolean getUseDM() {
        return !this.bDontUseDM;
    }

    boolean getUseUserStream() {
        return this.bUserStream;
    }

    boolean getUseFilterStream() {
        return this.bFilterStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] restoreIDs(int n) {
        long[] lArray;
        block10: {
            int n2;
            lArray = this.nlIDs[n];
            if (lArray != null) {
                return lArray;
            }
            File file = this.getUserFile(this.getIDsFileName(n));
            if (file != null && (n2 = (int)(file.length() / 8L)) > 0) {
                lArray = new long[n2];
                DataInputStream dataInputStream = V2CLocalFileHandler.getDataInputStream(file);
                if (dataInputStream != null) {
                    try {
                        try {
                            for (int i = 0; i < n2; ++i) {
                                lArray[i] = dataInputStream.readLong();
                            }
                            Object var8_8 = null;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            lArray = null;
                            Object var8_9 = null;
                            V2CLocalFileHandler.closeInputStream(dataInputStream);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        V2CLocalFileHandler.closeInputStream(dataInputStream);
                        throw throwable;
                    }
                    V2CLocalFileHandler.closeInputStream(dataInputStream);
                }
            }
        }
        if (lArray == null) {
            lArray = new long[]{};
        }
        this.nlIDs[n] = lArray;
        return lArray;
    }

    private boolean containedInIDs(long l, int n) {
        long[] lArray = this.restoreIDs(n);
        int n2 = lArray.length - 1;
        if (n2 <= 0) {
            return false;
        }
        int n3 = 0;
        long l2 = lArray[0];
        if (l <= l2) {
            return l == l2;
        }
        long l3 = lArray[n2];
        if (l >= l3) {
            return l == l3;
        }
        while (n3 < n2) {
            int n4 = (n3 + n2) / 2;
            long l4 = lArray[n4];
            if (l == l4) {
                return true;
            }
            if (l < l4) {
                if (n2 == n4) {
                    return false;
                }
                n2 = n4;
                continue;
            }
            if (n3 == n4) {
                return false;
            }
            n3 = n4;
        }
        return false;
    }

    boolean isFollowing(long l) {
        return this.containedInIDs(l, 0);
    }

    int getFollowState(long l) {
        return (this.containedInIDs(l, 0) ? 1 : 0) | (this.containedInIDs(l, 1) ? 2 : 0);
    }

    boolean isNoRetweet(long l) {
        return this.containedInIDs(l, 2);
    }

    boolean isBlocking(long l) {
        return this.containedInIDs(l, 3);
    }

    private String getIDsFileName(int n) {
        switch (n) {
            case 0: {
                return sFriendsFileName;
            }
            case 1: {
                return sFollowersFileName;
            }
            case 2: {
                return sNoRetweetFileName;
            }
            case 3: {
                return sBlockingFileName;
            }
        }
        return null;
    }

    void removeFromIDs(long l, int n) {
        int n2;
        if (l <= 0L) {
            return;
        }
        long[] lArray = this.nlIDs[n];
        if (lArray == null || (n2 = lArray.length) == 0) {
            return;
        }
        int n3 = -1;
        for (int i = n2 - 1; i >= 0; --i) {
            if (lArray[i] != l) continue;
            n3 = i;
            break;
        }
        if (n3 < 0) {
            return;
        }
        long[] lArray2 = new long[n2 - 1];
        if (n2 > 1) {
            if (n3 > 0) {
                System.arraycopy(lArray, 0, lArray2, 0, n3);
            }
            if (n3 < n2 - 1) {
                System.arraycopy(lArray, n3 + 1, lArray2, n3, n2 - n3 - 1);
            }
        }
        this.setIDs(lArray2, n);
    }

    void addToIDs(long l, int n) {
        long[] lArray;
        int n2;
        if (l <= 0L) {
            return;
        }
        long[] lArray2 = this.nlIDs[n];
        if (lArray2 != null && (n2 = lArray2.length) > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                if (lArray2[i] != l) continue;
                return;
            }
            lArray = new long[n2 + 1];
            System.arraycopy(lArray2, 0, lArray, 0, n2);
            lArray[n2] = l;
        } else {
            lArray = new long[]{l};
        }
        this.setIDs(lArray, n);
    }

    boolean updateFriends(List list) {
        if (list == null) {
            return false;
        }
        int n = list.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Number)) {
                return false;
            }
            lArray[i] = ((Number)e).longValue();
        }
        Arrays.sort(lArray);
        long[] lArray2 = this.nlIDs[0];
        if (lArray2 != null && lArray2.length == n) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == lArray2[i]) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        this.setIDs(lArray, 0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setIDs(long[] lArray, int n) {
        if (lArray == null) {
            return;
        }
        Arrays.sort(lArray);
        this.nlIDs[n] = lArray;
        File file = this.getUserFile(this.getIDsFileName(n));
        if (file == null) {
            return;
        }
        DataOutputStream dataOutputStream = V2CLocalFileHandler.getDataOutputStream(file);
        if (dataOutputStream == null) {
            return;
        }
        try {
            try {
                int n2 = lArray.length;
                for (int i = 0; i < n2; ++i) {
                    dataOutputStream.writeLong(lArray[i]);
                }
                Object var8_8 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var8_9 = null;
                V2CLocalFileHandler.closeOutputStream(dataOutputStream);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            V2CLocalFileHandler.closeOutputStream(dataOutputStream);
            throw throwable;
        }
        V2CLocalFileHandler.closeOutputStream(dataOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getRateLimits(String string) {
        HashMap hashMap;
        long[] lArray = null;
        HashMap hashMap2 = hashMap = this.vRateLimitMap;
        synchronized (hashMap2) {
            lArray = (long[])hashMap.get(string);
        }
        return lArray != null ? lArray : new long[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectionInfo(HttpURLConnection httpURLConnection, String string) {
        int n;
        int n2;
        if (!this.isOK() || httpURLConnection == null) {
            return;
        }
        long l = V2CMiscUtil.parseLong(httpURLConnection.getHeaderField("X-Rate-Limit-Reset"), -1L);
        long l2 = httpURLConnection.getDate() / 1000L;
        if (l2 > 0L) {
            this.ltServerDate = l2;
        }
        if (l2 <= 0L || l <= 0L || l <= l2) {
            return;
        }
        String string2 = httpURLConnection.getHeaderField("X-Access-Level");
        if (string2 != null) {
            String string3 = this.sOAAccessLevel;
            this.sOAAccessLevel = string2;
            if (!string2.equals(string3)) {
                V2CTwitterUser.saveUsers();
            }
        }
        int n3 = V2CMiscUtil.parseInt(httpURLConnection.getHeaderField("X-Rate-Limit-Remaining"), -1);
        int n4 = V2CMiscUtil.parseInt(httpURLConnection.getHeaderField("X-Rate-Limit-Limit"), -1);
        if (string != null && (n2 = string.indexOf(63)) > 0) {
            string = string.substring(0, n2);
        }
        HashMap hashMap = this.vRateLimitMap;
        Serializable serializable = hashMap;
        synchronized (serializable) {
            hashMap.put(string, new long[]{n3, l, n4});
        }
        serializable = this.vUpdateUserInfoTimer;
        if (serializable != null) {
            return;
        }
        if (this.bInfoUpdated) {
            n = 3600;
        } else {
            this.bInfoUpdated = true;
            n = 60;
        }
        serializable = new Timer(n * 1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                V2CTwitterUser.this.performInfoUpdate();
            }
        });
        this.vUpdateUserInfoTimer = serializable;
        ((Timer)serializable).setRepeats(false);
        ((Timer)serializable).start();
    }

    void performInfoUpdate() {
        int n;
        if (!this.isOK()) {
            return;
        }
        long l = this.ltLastInfoUpdate;
        long l2 = System.currentTimeMillis();
        if (l2 < l + 600000L) {
            this.vUpdateUserInfoTimer = null;
            return;
        }
        this.ltLastInfoUpdate = l2;
        int n2 = 8;
        int n3 = n = this.iUserInfoUpdateCount;
        for (int i = 0; i < n2 && (n = V2CTwitterBBS.performInfoUpdate(this, n)) != n3; ++i) {
        }
        this.iUserInfoUpdateCount = n;
        this.vUpdateUserInfoTimer = null;
    }

    boolean accessToDMForbidden(V2CHttpUtil.CAndC cAndC) {
        if (this.bDontUseDM) {
            return true;
        }
        String string = this.sOAAccessLevel;
        if (string == null || string.matches(".*\\bdirectmessages\\b.*")) {
            return false;
        }
        List list = V2CTwitterThreadRes.getArrayFromMap(cAndC.getErrorJSONObject(), "errors");
        if (list == null) {
            return false;
        }
        boolean bl = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            if (V2CTwitterThreadRes.getLongFromMap(list.get(i), "code") != 93L) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        if (!this.bDMForbiddenWarned) {
            this.bDMForbiddenWarned = true;
            V2CSwingUtil.showMessageLater("\u3053\u306e\u30a2\u30ab\u30a6\u30f3\u30c8\uff08" + this.sUserName + "\uff09\u3067\u306f\u73fe\u5728\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u53d6\u5f97\u30fb\u524a\u9664\u304c\u3067\u304d\u307e\u305b\u3093\u3002\n\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u53d6\u5f97\u30fb\u524a\u9664\u3092\u3059\u308b\u305f\u3081\u306b\u306f\nOAuth\u3067\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u518d\u8a8d\u8a3c\u3092\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002", "Twitter DM\u8b66\u544a", 2);
        }
        return true;
    }

    V2CPackedPropValue getSaveValue() {
        if (!this.isOK()) {
            return null;
        }
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setLong('I', this.nID);
        V2CMiscUtil.setBase64String(this.sUserName, v2CPackedPropValue, 'U');
        String string = this.sOAuthAccessToken;
        String string2 = this.sOAuthAccessTokenSecret;
        if (string != null && string2 != null) {
            V2CMiscUtil.setBase64String(string, v2CPackedPropValue, 'T');
            V2CMiscUtil.setBase64String(string2, v2CPackedPropValue, 'S');
        }
        v2CPackedPropValue.setString('L', this.sOAAccessLevel);
        if (this.cMentionBG != null) {
            v2CPackedPropValue.setColor('R', this.cMentionBG);
        }
        if (this.cWritePanelBG != null) {
            v2CPackedPropValue.setColor('B', this.cWritePanelBG);
        }
        v2CPackedPropValue.setBoolean('D', this.bDontUseDM);
        v2CPackedPropValue.setBoolean('M', this.bUserStream);
        v2CPackedPropValue.setBoolean('F', this.bFilterStream);
        return v2CPackedPropValue;
    }

    public String toString() {
        String string = this.sUserName;
        String string2 = this.sOAAccessLevel;
        if (string2 != null && !string2.matches(".*\\bdirectmessages\\b.*")) {
            string = string + "(DM\u4e0d\u53ef)";
        }
        return string;
    }
}

