/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTabSelectionListener;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CWriteMessagePanel;
import org.monazilla.v2c.V2CWritePanel;

public class V2CWriteWindow
extends V2CWritePanel
implements ActionListener,
WindowListener,
V2CTabSelectionListener {
    private static final String sConfKey = "WritePanel.WindowConf";
    static Rectangle rWindow;
    static boolean bShrinkable;
    JDialog jDialog;
    JPanel jpWarning;
    boolean bWarning;
    Timer tResizeTimer;
    int nResizeCount;
    Dimension dShrinked;
    Rectangle rDialogBounds;
    Dimension dFullSize;
    Dimension dRestoredSize;

    static boolean isShrinkable() {
        return bShrinkable && V2CWriteWindow.isShrinkSupported();
    }

    static boolean isShrinkSupported() {
        return true;
    }

    static void setShrinkable(boolean bl) {
        if (V2CWriteWindow.isShrinkSupported() && bl != bShrinkable) {
            bShrinkable = bl;
            V2CWriteWindow.saveWindowConf();
        }
    }

    static void saveWindowConf() {
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (rWindow != null || bShrinkable) {
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            if (rWindow != null) {
                v2CPackedPropValue.setRectangle('B', rWindow);
            }
            v2CPackedPropValue.setBoolean('S', bShrinkable);
            v2CProperty.putPackedValue(sConfKey, v2CPackedPropValue);
        } else {
            v2CProperty.remove(sConfKey);
        }
    }

    public V2CWriteWindow(V2CThreadPanel v2CThreadPanel) {
        super(v2CThreadPanel);
        if (V2CApp.isWinType()) {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    Dimension dimension = V2CWriteWindow.this.dRestoredSize;
                    JDialog jDialog = V2CWriteWindow.this.jDialog;
                    if (dimension != null && jDialog != null) {
                        Dimension dimension2 = jDialog.getSize();
                        if (dimension2.equals(V2CWriteWindow.this.dShrinked)) {
                            jDialog.pack();
                        }
                        V2CWriteWindow.this.dRestoredSize = null;
                    }
                }
            });
        }
    }

    void createToolBar() {
        this.createToolBar("WriteWindow");
        AbstractButton abstractButton = this.abTogglePreview;
        if (abstractButton != null) {
            V2CAbstractAction v2CAbstractAction = (V2CAbstractAction)abstractButton.getAction();
            V2CAction.ToggleWritePreview toggleWritePreview = new V2CAction.ToggleWritePreview();
            toggleWritePreview.setName("ToggleWritePreview");
            Icon icon = abstractButton.getIcon();
            abstractButton.setAction(toggleWritePreview);
            abstractButton.setIcon(icon);
            v2CAbstractAction.removeButton(abstractButton);
        }
    }

    JPanel createWarning() {
        JPanel jPanel;
        this.jpWarning = jPanel = new JPanel();
        jPanel.setBackground(Color.RED);
        jPanel.setPreferredSize(new Dimension(10, 10));
        jPanel.setMaximumSize(new Dimension(10, 100));
        return jPanel;
    }

    boolean isInWindow() {
        return true;
    }

    boolean setPanelVisible(boolean bl) {
        Serializable serializable;
        JDialog jDialog = this.jDialog;
        if (bl) {
            this.bWarning = false;
            if (this.jpWarning != null) {
                this.jpWarning.setOpaque(false);
            }
            if (jDialog == null) {
                this.jDialog = jDialog = new JDialog(V2CMain.v2cMain, this.bNewThread ? this.vThreadPanel.getThreadItem().getTitle() : '\u300e' + this.vThreadPanel.getTitleString() + "\u300f\u306b\u30ec\u30b9", false);
                if (V2CApp.isWinType()) {
                    jDialog.getRootPane().enableInputMethods(false);
                }
                jDialog.setDefaultCloseOperation(0);
                jDialog.getContentPane().add((Component)this, "Center");
                if (rWindow != null) {
                    Rectangle rectangle = rWindow;
                    V2CSwingUtil.checkWindowPosition(rectangle);
                    jDialog.setBounds(rectangle);
                } else {
                    jDialog.setSize(400, 300);
                }
                jDialog.addWindowListener(this);
                V2CMain.v2cMain.addWindowListener(this);
                V2CMain.getDisplayPane().addTabSelectionListner(this);
                jDialog.setVisible(true);
            } else {
                jDialog.toFront();
                if (!jDialog.isVisible()) {
                    jDialog.setVisible(true);
                }
            }
            return true;
        }
        if (jDialog != null) {
            V2CMain.v2cMain.removeWindowListener(this);
            V2CMain.getDisplayPane().removeTabSelectionListner(this);
            serializable = jDialog.getBounds();
            if (this.dFullSize != null) {
                Insets insets = jDialog.getInsets();
                ((Rectangle)serializable).width = this.dFullSize.width + insets.left + insets.right;
                ((Rectangle)serializable).height = this.dFullSize.height + insets.top + insets.bottom;
                this.dFullSize = null;
            }
            rWindow = serializable;
            V2CWriteWindow.saveWindowConf();
            jDialog.setVisible(false);
            jDialog.dispose();
            jDialog.getContentPane().remove(this);
            this.jDialog = null;
        }
        return (serializable = (V2CWriteMessagePanel)this.getSelectedPanel()) != null ? serializable.writePanelHidden() : true;
    }

    void armRequestFocus(boolean bl) {
        if (this.dFullSize != null) {
            this.setShrink(false);
        }
        super.armRequestFocus(bl);
    }

    public void tabSelected(V2CPanel v2CPanel) {
        boolean bl;
        boolean bl2 = bl = v2CPanel != this.vThreadPanel;
        if (bl != this.bWarning) {
            this.bWarning = bl;
            if (this.jpWarning != null) {
                this.jpWarning.setOpaque(bl);
                this.jpWarning.repaint();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tResizeTimer) {
            if (this.dFullSize != null) {
                return;
            }
            JDialog jDialog = this.jDialog;
            Dimension dimension = this.dShrinked;
            if (jDialog == null || this.nResizeCount <= 0 || dimension == null) {
                return;
            }
            Dimension dimension2 = jDialog.getSize();
            if (!dimension2.equals(dimension)) {
                this.dRestoredSize = dimension2;
                return;
            }
            --this.nResizeCount;
            jDialog.pack();
            this.tResizeTimer.start();
        }
    }

    void setShrink(final boolean bl) {
        if (bl && !V2CWriteWindow.isShrinkable()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                V2CWriteWindow.this.setShrink0(bl);
            }
        });
    }

    private void setShrink0(boolean bl) {
        boolean bl2;
        Dimension dimension = this.dFullSize;
        boolean bl3 = bl2 = this.dFullSize != null;
        if (V2CWriteWindow.isShrinkable() ? bl == bl2 : bl || !bl2) {
            return;
        }
        JDialog jDialog = this.jDialog;
        if (jDialog == null) {
            return;
        }
        boolean bl4 = !bl;
        Container container = jDialog.getContentPane();
        if (bl4) {
            this.dShrinked = jDialog.getSize();
            int n = this.getHeight();
            if (dimension.height < n + 100) {
                dimension.height = n + 100;
            }
            this.setPreferredSize(dimension);
            this.invalidate();
            jDialog.pack();
            this.dFullSize = null;
            this.nResizeCount = 30;
            Timer timer = this.tResizeTimer;
            if (timer == null) {
                timer = new Timer(100, this);
                timer.setRepeats(false);
                this.tResizeTimer = timer;
            }
            timer.start();
        } else {
            this.dShrinked = null;
            this.rDialogBounds = jDialog.getBounds();
            Rectangle rectangle = this.getBounds();
            this.dFullSize = new Dimension(rectangle.width, rectangle.height);
            this.setPreferredSize(new Dimension(rectangle.width, 1));
            this.invalidate();
            jDialog.pack();
        }
        if (V2CApp.isMacintosh()) {
            Component component = jDialog.getGlassPane();
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(bl);
            }
            component.setVisible(bl);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getComponent() == this.jDialog) {
            if (this.vThreadPanel.isNewThread()) {
                V2CMain.getDisplayPane().removePanel(this.vThreadPanel);
            } else {
                this.vThreadPanel.closeWritePanel(false);
            }
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        boolean bl;
        boolean bl2;
        Component component = windowEvent.getComponent();
        if (component == this.jDialog) {
            bl2 = false;
        } else if (component == V2CMain.v2cMain) {
            bl2 = true;
        } else {
            return;
        }
        this.dRestoredSize = null;
        boolean bl3 = bl = this.dFullSize != null;
        if (V2CWriteWindow.isShrinkable() ? bl != bl2 : bl && !bl2) {
            this.setShrink(bl2);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static {
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(sConfKey);
        if (v2CPackedPropValue != null) {
            rWindow = v2CPackedPropValue.getRectangle('B');
            bShrinkable = v2CPackedPropValue.getBoolean('S');
        }
    }
}

