package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;

import org.monazilla.v2c.V2CHttpUtil.CAndC;
import org.monazilla.v2c.V2CHttpUtil.RemoteHost;

public abstract class DatUpdater {
	protected DatUpdater next;
	public DatUpdater(DatUpdater next) {
		this.next = next;
	}

	public DatUpdater() {
		this(null);
	}

	protected abstract URL getURL(URL url);
	
	protected void prepareHttpConnection(HttpURLConnection conn) {
		return;
	}

	protected abstract void commitHTTP(HttpURLConnection conn)
			throws IOException;

	protected CAndC handleResponse(HttpURLConnection conn) throws IOException {
		int responseCode = conn.getResponseCode();
		CAndC candc = new CAndC(conn);
		candc.setError(true);
		if (responseCode < 300) {
			candc.setError(false);
			return candc;
		} else if (responseCode == 302) {
			candc.setError(false);
			return candc;
		} else if (responseCode == 304) {
			return null;
		} else if (responseCode >= 300 && responseCode < 400) {
			logRemoteHostError(conn.getURL());
			return null;
		} else if (responseCode == 416) {
			return null;
		} else if (responseCode >= 400 && responseCode < 500) {
			logRemoteHostError(conn.getURL());
			return null;
		} else if (responseCode >= 500) {
			logRemoteHostError(conn.getURL());
			return null;
		}
		candc.setError(false);
		return candc;
	}

	public CAndC updateDat(URL url, int startPos, long lastModified,
			String eTag, V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs,
			boolean acceptGZ) throws IOException {
		if (url == null || isLocalURL(url)) {
			return null;
		}
		if (!isOnlineMode()) {
			logNotOnline(url);
			return null;
		}
		url = checkShitarabaURL(url);
		url = getURL(url);

		Thread thread = Thread.currentThread();
		RemoteHost remotehost = getRemoteHost(url);
		remotehost.start();
		try {
			if (thread.isInterrupted()) {
				logInterrupt(url);
				return null;
			}
			HttpURLConnection conn = openReadConnection(url);
			setTimeout(conn);
			conn.setRequestProperty("Host", url.getHost());
			conn.setRequestProperty("Accept", "*/*");
			conn.setRequestProperty("User-Agent", v2cbbs != null
					&& !is2chEq(v2cbbs)
					? V2CHttpUtil.getUAName()
					: "Mozilla/4.0 (compatible)");
			if (startPos > 0 && lastModified > 0L) {
				conn.setIfModifiedSince(lastModified);
				if (eTag != null && eTag.length() > 0) {
					conn.setRequestProperty("If-None-Match", eTag);
				}
			}
			boolean useRange = startPos > 0 && useRangeRequestHeader(v2cbbs);
			if (useRange) {
				conn.setRequestProperty("Range", "bytes=" + startPos + "-");
				conn.setRequestProperty("Accept-Encoding", "identity");
			} else if (!acceptGZ) {
				conn.setRequestProperty("Accept-Encoding", "gzip");
			}
			logHTTPRequest(conn, "Dat Request:");
			commitHTTP(conn);
			checkRemoteHost(remotehost);
			if (thread.isInterrupted()) {
				logInterrupt(url);
				return null;
			}
			logHTTPResponse(conn, "Dat Response: ");
			CAndC candc = handleResponse(conn);
			if (null == candc) {
				return new CAndC(conn);// unknown error, should not continue
			}
			if (!candc.isError()) {
				return fillCAndC(conn, candc, v2cbbsthreadres, v2cbbs,
						startPos, acceptGZ, remotehost);
			} else { // error
				if (null != next) {
					return next.updateDat(url, startPos, lastModified, eTag,
							v2cbbsthreadres, v2cbbs, acceptGZ);
				} else {
					return candc;
				}
			}
		} finally {
			remotehost.finished();
		}
	}

	protected boolean isLocalURL(URL url) {
		return url != null && url.toString().startsWith("http://localboard/");
	}

	protected boolean isOnlineMode() {
		return V2CMain.isOnlineMode();
	}

	protected URL checkShitarabaURL(URL url) {
		String s = url.getHost();
		if (s == null || !s.startsWith("jbbs."))
			return url;
		try {
			url = new URL(V2CJBBSShitarabaBBS.unnormalizeURL(url
					.toExternalForm()));
		} catch (MalformedURLException malformedurlexception) {
			V2CMiscUtil.printMalformedURLException(malformedurlexception);
		}
		return url;
	}

	protected URL str2URL(String s) {
		try {
			return new URL(s);
		} catch (MalformedURLException malformedurlexception) {
			V2CMiscUtil.printMalformedURLException(malformedurlexception);
		}
		return null;
	}

	protected RemoteHost getRemoteHost(URL url) {
		return V2CHttpUtil.getRemoteHost(url);
	}

	protected void checkRemoteHost(RemoteHost remote) {
		remote.check();
	}

	protected boolean checkContentType(String s, String s1) {
		return s1 == null || s != null
				&& (V2CMiscUtil.isEqual(s, s1) || s.startsWith(s1 + ';'));
	}

	protected void logHTTPResponse(HttpURLConnection httpurlconnection, String s)
			throws IOException {
		V2CLogger.logHTTPHeaderFields(httpurlconnection.getURL(), s,
				httpurlconnection.getHeaderFields());
	}

	protected void logHTTPRequest(HttpURLConnection conn, String s)
			throws IOException {
		V2CLogger.logHTTPHeaderFields(conn.getURL(), s, conn.getHeaderFields());
	}

	protected void logRemoteHostError(URL url) {
		V2CLogger.logError(url, "    Error in getRemoteHost(u).");
	}

	protected void logInterrupt(URL url) {
		V2CLogger.logInfo(url, "    Interrupt detected.");
	}

	protected void logNotOnline(URL url) {
		V2CLogger.logInfo(url, "    Not online.");
	}

	protected void logNotOnline(String s) {
		V2CLogger.logInfo(s, "    Not online.");
	}

	protected HttpURLConnection openReadConnection(URL url) throws IOException {
		return V2CProxySetting.openReadConnection(url);
	}

	protected boolean isO2onUsed() {
		return V2CProxySetting.isO2onUsed();
	}

	protected void setTimeout(HttpURLConnection conn) {
		V2CHttpUtil.setTimeout(conn);
	}

	protected boolean is2chEq(V2CBBS v2cbbs) {
		return v2cbbs.is2chEq();
	}

	protected boolean is2ch(V2CBBS v2cbbs) {
		return v2cbbs.is2ch();
	}

	protected boolean useRangeRequestHeader(V2CBBS v2cbbs) {
		return v2cbbs.useRangeRequestHeader();
	}

	protected String getDatContentType(V2CBBS v2cbbs) {
		return v2cbbs.getDatContentType();
	}

	protected boolean contentTypeStartsWith(String content, String contentType,
			boolean flag) {
		return V2CMiscUtil.contentTypeStartsWith(content, contentType, flag);
	}

	protected void setContentLength(V2CBBSThreadRes v2cbbsthreadres, int len) {
		v2cbbsthreadres.setContentLength(len);
	}

	protected void setHeaderFields(V2CBBSThreadRes v2cbbsthreadres,
			HttpURLConnection conn) {
		v2cbbsthreadres.setHeaderFields(conn);
	}

	protected boolean appendToDatFile(V2CBBSThreadRes v2cbbsthreadres,
			byte[] buff, int len) {
		return v2cbbsthreadres.appendToDatFile(buff, len);
	}

	protected void addProgressValue(V2CBBSThreadRes v2cbbsthreadres, int k) {
		v2cbbsthreadres.addProgressValue(k);
	}

	protected String getBoardCharset(V2CBBSThreadRes v2cbbsthreadres) {
		return v2cbbsthreadres.getThreadItem().getBoardItem()
				.getCharsetString();
	}

	protected boolean checkFirstLine(V2CBBSThreadRes v2cbbsthreadres) {
		return v2cbbsthreadres.bCheckFirstLine;
	}

	protected CAndC fillCAndC(HttpURLConnection conn, CAndC candc,
			V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs, int startPos,
			boolean acceptGZ, RemoteHost remotehost) throws IOException {
		InputStream istream = null;
		BufferedReader bufferedreader = null;
		boolean useRange = startPos > 0 && useRangeRequestHeader(v2cbbs);
		int responseCode = conn.getResponseCode();
		String contentType = conn.getContentType();
		URL url = conn.getURL();
		if (responseCode == 302) {
			responseCode = 0;
		}
		try {
			boolean polipoDetection;
			boolean isGZip;
			polipoDetection = useRange && responseCode == 200;
			if (polipoDetection) {
				int k = conn.getContentLength();
				String s3 = conn.getHeaderField("Connection");
				if (k <= startPos || s3 == null || !s3.equals("keep-alive")) {
					polipoDetection = false;
				}
			}
			if (polipoDetection && !V2CHttpUtil.bPolipoWarned
					&& !V2CHttpUtil.useAPI) {
				V2CHttpUtil.bPolipo = true;
			}
			String contentEncoding = conn.getContentEncoding();
			isGZip = acceptGZ || contentEncoding != null
					&& contentEncoding.equals("gzip");
			if ((contentType == null || !contentTypeStartsWith(contentType,
					getDatContentType(v2cbbs), true))) {
				boolean contentTypeError = false;
				if (contentType != null) {
					String s4 = url.toString();
					if (isGZip
							&& (contentType
									.equalsIgnoreCase("application/x-gzip") || contentType
									.equalsIgnoreCase("text/html"))
							&& is2ch(v2cbbs)
							&& url.toString().endsWith(".dat.gz")) {
						contentTypeError = true;
					} else if (contentType
							.equalsIgnoreCase("application/octet-stream")) {
						contentTypeError = s4
								.startsWith("http://ookamitokari2.run.buttobi.net/ookamikakolog/")
								|| s4.startsWith("http://www.2ich.net/");
					} else if (contentType
							.equalsIgnoreCase("chemical/x-mopac-input")) {
						contentTypeError = s4
								.startsWith("http://tmhkym.net/maka/bbs/maka/");
					}
				} else if (is2ch(v2cbbs)) {
					contentTypeError = true;
				}
				if (!contentTypeError) {
					return new CAndC("Content-Typeが"
							+ getDatContentType(v2cbbs) + "で始まっていません。（"
							+ contentType + "）");
				}
			}
			istream = conn.getInputStream();
			if (isGZip) {
				try {
					istream = new GZIPInputStream(
							new V2CHttpUtil.GZIPFilterInputStream(istream,
									v2cbbsthreadres));
				} catch (IOException ioexception1) {
					if (responseCode == 302 && isO2onUsed()) {
						return candc;
					}
					throw ioexception1;
				}
			}
			int j1;
			byte abyte0[];
			int i1 = conn.getContentLength();
			setContentLength(v2cbbsthreadres,
					polipoDetection ? Math.max(i1 - startPos, 1) : i1);
			setHeaderFields(v2cbbsthreadres, conn);
			j1 = polipoDetection ? startPos : 0;
			abyte0 = new byte[V2CHttpUtil.nBufLen];
			while (true) {
				checkRemoteHost(remotehost);
				int k1 = istream.read(abyte0);
				if (Thread.currentThread().isInterrupted()) {
					logInterrupt(url);
					return null;
				}
				if (k1 < 0) {
					if (checkFirstLine(v2cbbsthreadres)) {
						appendToDatFile(v2cbbsthreadres, abyte0, 0);
						break;
					}
					break;
				}
				if (k1 > 0) {
					if (j1 > 0) {
						if (j1 >= k1) {
							j1 -= k1;
						} else {
							k1 -= j1;
							System.arraycopy(abyte0, j1, abyte0, 0, k1);
							j1 = 0;
						}
					} else {
						if (!appendToDatFile(v2cbbsthreadres, abyte0, k1)) {
							break;
						}
						if (!isGZip) {
							addProgressValue(v2cbbsthreadres, k1);
						}
					}
				}
			}
			StringBuffer stringbuffer;
			bufferedreader = new BufferedReader(new InputStreamReader(istream,
					getBoardCharset(v2cbbsthreadres)));
			stringbuffer = new StringBuffer();
			String line;
			while ((line = bufferedreader.readLine()) != null) {
				if (Thread.currentThread().isInterrupted()) {
					logInterrupt(url);
					return null;
				}
				stringbuffer.append(line);
			}
			candc.setContents(stringbuffer.toString());
			return candc;
		} finally {
			try {
				istream.close();
			} catch (IOException ignore) {
			}
		}
	}
}
