package org.monazilla.v2c.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Key;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import org.monazilla.v2c.DatUpdater;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CHttpUtil.CAndC;

@SuppressWarnings("rawtypes")
public class APIDatUpdater extends DatUpdater {

	private String appKey;
	private String hmKey;

	private String sid;
	public APIDatUpdater(String appKey, String hmKey) {
		this(appKey, hmKey, null);
	}

	public APIDatUpdater(String appKey, String hmKey, DatUpdater next) {
		super(next);
		this.appKey = appKey;
		this.hmKey = hmKey;
		try {
			fireAuthenticate();

		} catch (Exception e) {
			e.printStackTrace();
		}
		Thread SID_updater = new Thread() {
			public void run() {
				while (true) {
					try {
						Thread.sleep(55 * 60 * 1000);
						fireAuthenticate();
					} catch (InterruptedException ie) {

					} catch (Exception ignore) {

					}
				}
			}
		};
		SID_updater.setDaemon(true);
		SID_updater.start();
	}

	public void fireAuthenticate() throws Exception {
		long current = System.currentTimeMillis();
		String CT = String.valueOf(current).substring(0, 10);
		String message = getAppKey() + CT;
		String HB = getHash(message);
		PrintStream out = null;
		BufferedReader buff = null;
		try {
			URL url = new URL("https://api.2ch.net/v1/auth/");
			String param = "ID=&PW=&KY=" + getAppKey() + "&CT=" + CT + "&HB="
					+ HB;

			HttpURLConnection con = (HttpURLConnection) url.openConnection();
			con.setDoOutput(true);
			con.setRequestMethod("POST");
			con.setRequestProperty("User-Agent", "");
			con.setRequestProperty("X-2ch-UA", V2CHttpUtil.X2CHUA);
			out = new PrintStream(con.getOutputStream());
			out.print(param);
			out.flush();

			buff = new BufferedReader(new InputStreamReader(
					con.getInputStream()));
			String line;
			while ((line = buff.readLine()) != null) {
				System.out.println(line);
				if (line.startsWith("SESSION-ID")) {
					sid = line.split(":")[1];
				}
			}
		} finally {
			try {
				out.close();
			} catch (Exception ignore) {
			}
			try {
				buff.close();
			} catch (Exception ignore) {
			}
		}

	}

	public String getAppKey() {
		return appKey;
	}

	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getHmKey() {
		return hmKey;
	}

	public void setHmKey(String hmKey) {
		this.hmKey = hmKey;
	}

	private static final Pattern pattern = Pattern
			.compile("http://([^\\.]*)\\.2ch\\.net/([^/]*)/dat/([0-9]*)\\.dat");

	ThreadLocal currentUri = new ThreadLocal();
	ThreadLocal is2ch = new ThreadLocal();

	private String getHash(String message) {
		try {
			Key key = new SecretKeySpec(V2CHttpUtil.getHMKey().getBytes(),
					"HmacSHA256");
			Mac mac = Mac.getInstance(key.getAlgorithm());
			mac.init(key);
			byte[] data = mac.doFinal(message.getBytes());
			StringBuffer sb = new StringBuffer();
			for (byte b : data) {
				String s = Integer.toHexString(0xff & b);
				if (s.length() == 1) {
					sb.append("0");
				}
				sb.append(s);
			}
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	protected URL getURL(URL url) {
		String original = url.toString();
		Matcher matcher = pattern.matcher(original);
		if (matcher.matches()) {
			boolean is2chDAT = true;
			is2ch.set(is2chDAT);
			String server = matcher.group(1);
			String board = matcher.group(2);
			String threadId = matcher.group(3);
			String uri = "/v1/" + server + "/" + board + "/" + threadId;
			currentUri.set(uri);
			url = str2URL("https://api.2ch.net" + uri);
		}
		return url;
	}

	@Override
	protected void prepareHttpConnection(HttpURLConnection conn) {
		conn.setDoOutput(true);
		try {
			conn.setRequestMethod("POST");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	protected void commitHTTP(HttpURLConnection conn) throws IOException {
		if (null == sid) {
			return;
		}
		String message = currentUri.get() + sid + V2CHttpUtil.getAppKey();
		String hobo = getHash(message);
		String param = "sid=" + sid + "&hobo=" + hobo + "&appkey="
				+ V2CHttpUtil.getAppKey();
		PrintStream out = new PrintStream(conn.getOutputStream());
		out.print(param);
		out.flush();
	}

	@Override
	protected CAndC handleResponse(HttpURLConnection conn) throws IOException {
		int responseCode = conn.getResponseCode();
		System.out.println(responseCode);
		CAndC candc = new CAndC(conn);
		candc.setError(true);
		if (sid == null) {
			// APIは使えない状態
			return candc;
		}
		if (responseCode < 300) {
			if ((Boolean) is2ch.get()) {
				int len = conn.getContentLength();
				if (len == 3 && responseCode == 200) {
					candc.setErrorMessage("APIのバグ対応中");
					return candc;
				}
				candc.setError(false);
				return candc;
			}
		} else if (responseCode == 302) {
			candc.setError(false);
			return candc;
		} else if (responseCode == 304) {
			return null;
		} else if (responseCode >= 300 && responseCode < 400) {
			logRemoteHostError(conn.getURL());
			return null;
		} else if (responseCode == 416) {
			return null;
		} else if (responseCode >= 400 && responseCode < 500) {
			String etag = conn.getHeaderField("ETag");
			if ((Boolean) is2ch.get() && etag == null) {// 過去ログ取得を失敗
				return candc;
			} else {
				return null;// APIのよくあるバグなので無視
			}
		} else if (responseCode >= 500) {
			if ((Boolean) is2ch.get()) {
				return candc;
			} else {
				logRemoteHostError(conn.getURL());
				return null;
			}
		}
		candc.setError(false);
		return candc;
	}
}
