package org.monazilla.v2c.impl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.monazilla.v2c.DatUpdater;

public class SCDatUpdater extends DatUpdater {

	public SCDatUpdater(DatUpdater next) {
		super(next);
	}

	private static final Pattern pattern = Pattern
			.compile("http://([^\\.]*)\\.2ch\\.net/([^/]*)/dat/([0-9]*)\\.dat");
	@Override
	protected URL getURL(URL url) {
		Matcher matcher = pattern.matcher(url.toString());
		if (matcher.matches()) {
			url = str2URL(url.toString().replace(".2ch.net", ".2ch.sc"));
		}
		return url;
	}

	@Override
	protected void commitHTTP(HttpURLConnection conn) throws IOException {
		return;
	}

}
